package cn.tenfell.plugins.controllerfree.inface;

import javax.servlet.http.HttpServletRequest;

/**
 * 全局拦截器和登录用户接口
 * @author fs
 */
public interface NoControllerInterface {
    /**
     * 根据request获取用户信息
     * @param request request
     * @return 用户实体
     */
    Object getLoginUser(HttpServletRequest request);

    /**
     * 全局拦截器方法
     * @param e 拦截的异常
     * @return 返回到前端数据
     */
    Object errorHandler(Throwable e);

    /**
     * 全局错误码拦截
     * @param status 错误码
     * @return 返回到前端数据
     */
    Object errorHandler(int status);
}
