package cn.tenfell.plugins.controllerfree.annotation;
import cn.tenfell.plugins.controllerfree.entity.EmptyClass;

import java.lang.annotation.*;
/**
 * 文档方法注解
 * @author fs
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
public @interface InterfaceDoc {
    /**
     * 接口名称
     * @return 接口名称
     */
    String name() default "";

    /**
     * 接口参数列表
     * @return 接口参数列表
     */
    InterfaceForm[] params() default {};

    /**
     * 接口校验实体
     * @return 接口校验实体
     */
    Class entity() default EmptyClass.class;

    /**
     * 接口校验分组
     * @return 接口校验分组
     */
    Class<?>[] groups() default {};
}

