package cn.tenfell.plugins.controllerfree.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 配置信息
 * @author fs
 */
@Component
@ConfigurationProperties(prefix="cn.tenfell.plugins.ctrlfree")
@Data
public class ControllerFreeProperties {
    /**
     * 文档访问密码
     */
    private String password;
    /**
     * 接口限制登录,默认为CLOSE
     */
    private NeedLogin defaultNeedLogin;
    public enum NeedLogin{
        /**
         * 限制登录注解
         */
        OPEN("开启"),
        CLOSE("关闭");
        private String name;
        NeedLogin(String name){
            this.name = name;
        }
    }
}
