/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.controllerfree.component;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.controllerfree.annotation.InterfaceDoc;
import cn.tenfell.plugins.controllerfree.annotation.InterfaceField;
import cn.tenfell.plugins.controllerfree.annotation.InterfaceForm;
import cn.tenfell.plugins.controllerfree.annotation.InterfaceModule;
import cn.tenfell.plugins.controllerfree.annotation.NeedLogin;
import cn.tenfell.plugins.controllerfree.annotation.NotNeedLogin;
import cn.tenfell.plugins.controllerfree.config.ControllerFreeProperties;
import cn.tenfell.plugins.controllerfree.entity.EmptyClass;
import cn.tenfell.plugins.controllerfree.entity.InterfaceDocChild;
import cn.tenfell.plugins.controllerfree.entity.InterfaceDocEntity;
import cn.tenfell.plugins.controllerfree.entity.InterfaceParams;
import cn.tenfell.plugins.controllerfree.entity.PoData;
import cn.tenfell.plugins.controllerfree.entity.ServiceCacheData;
import cn.tenfell.plugins.controllerfree.entity.UriMap;
import cn.tenfell.plugins.controllerfree.inface.NoControllerInterface;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
public class UriHandComponent
implements ApplicationContextAware {
    private static InterfaceDoc defInterfaceDoc;
    private static List<InterfaceDocEntity> interfaceList;
    private static Validator validator;
    private static String interfaceCreateTime;
    public static final Map<String, UriMap> handMap;
    public static final String INTERFACE_URI = "/interface/doclist";
    private static NoControllerInterface noControllerInterface;
    public static final ControllerFreeProperties controllerFreeProperties;
    private static ApplicationContext applicationContext;
    private static Map<String, ServiceCacheData> serviceCacheDataMap;

    public static NoControllerInterface getNoControllerInterface() {
        return noControllerInterface;
    }

    public static Validator getValidator() {
        return validator;
    }

    public static PoData getDocData() {
        PoData data = PoData.create().set("list", interfaceList).set("time", interfaceCreateTime);
        return data;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ControllerFreeProperties properties = (ControllerFreeProperties)applicationContext.getBean(ControllerFreeProperties.class);
        String password = properties.getPassword();
        ControllerFreeProperties.NeedLogin needLogin = properties.getDefaultNeedLogin();
        if (needLogin == ControllerFreeProperties.NeedLogin.OPEN) {
            controllerFreeProperties.setDefaultNeedLogin(needLogin);
        }
        if (StrUtil.isBlank((CharSequence)controllerFreeProperties.getPassword()) && StrUtil.isNotBlank((CharSequence)password)) {
            controllerFreeProperties.setPassword(password);
        }
        UriHandComponent.applicationContext = applicationContext;
        try {
            NoControllerInterface noControllerInterface;
            UriHandComponent.noControllerInterface = noControllerInterface = (NoControllerInterface)applicationContext.getBean(NoControllerInterface.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RuntimeException("\u8bf7\u7528Spring\u7ec4\u4ef6\u5b9e\u73b0NoControllerInterface\u63a5\u53e3", e);
        }
        try {
            defInterfaceDoc = EmptyClass.class.getDeclaredMethod("emptyMethod", new Class[0]).getAnnotation(InterfaceDoc.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UriHandComponent.updateHandMap(null);
    }

    private static void updateHandMapOneService(Object service, String key) {
        Method[] methods;
        String[] conMappings = new String[]{"json", "jsonp"};
        Class targetClass = AopUtils.getTargetClass((Object)service);
        ServiceCacheData serviceCacheData = new ServiceCacheData();
        serviceCacheData.setTargetClass(targetClass);
        serviceCacheData.setServiceName(key);
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods = targetClass.getDeclaredMethods()) {
            Class<?>[] types = method.getParameterTypes();
            int type = UriHandComponent.getType(types);
            if (type == 0) continue;
            UriMap uriMap = new UriMap();
            uriMap.setService(service);
            uriMap.setMethod(method);
            uriMap.setParams(types);
            NeedLogin needLogin = method.getAnnotation(NeedLogin.class);
            NotNeedLogin notNeedLogin = method.getAnnotation(NotNeedLogin.class);
            uriMap.setNeedLogin(UriHandComponent.getNeedLogin(needLogin, notNeedLogin));
            if (type == 1) {
                for (String conMapping : conMappings) {
                    String mapKey = "/" + conMapping + "/" + key + "/" + method.getName();
                    handMap.put(mapKey, uriMap);
                }
            } else if (type == 2) {
                String mapKey = "/servlet/" + key + "/" + method.getName();
                handMap.put(mapKey, uriMap);
            }
            methodList.add(method);
        }
        serviceCacheData.setMethods(methodList);
        serviceCacheDataMap.put(key, serviceCacheData);
    }

    private static boolean getNeedLogin(NeedLogin needLogin, NotNeedLogin notNeedLogin) {
        boolean defaultLogin;
        ControllerFreeProperties.NeedLogin need = controllerFreeProperties.getDefaultNeedLogin();
        boolean bl = defaultLogin = need == ControllerFreeProperties.NeedLogin.OPEN;
        if (needLogin != null && notNeedLogin != null) {
            return defaultLogin;
        }
        if (needLogin == null && notNeedLogin == null) {
            return defaultLogin;
        }
        return needLogin != null;
    }

    public static void updateHandMap(String serviceName) {
        Map serviceMap = applicationContext.getBeansWithAnnotation(Service.class);
        if (StrUtil.isBlank((CharSequence)serviceName)) {
            Set keys = serviceMap.keySet();
            for (String key : keys) {
                Object service = serviceMap.get(key);
                UriHandComponent.updateHandMapOneService(service, key);
            }
        } else {
            Object service = serviceMap.get(serviceName);
            if (service == null) {
                return;
            }
            UriHandComponent.updateHandMapOneService(service, serviceName);
        }
        ThreadUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                UriHandComponent.updateInterfaceList();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void updateInterfaceList() {
        interfaceList = new ArrayList<InterfaceDocEntity>();
        String[] conMappings = new String[]{"json", "jsonp"};
        Set<String> keys = serviceCacheDataMap.keySet();
        for (String key : keys) {
            ServiceCacheData serviceCacheData = serviceCacheDataMap.get(key);
            InterfaceDocEntity interfaceDocEntity = null;
            ArrayList<InterfaceDocChild> interfaceDocChildren = null;
            Class targetClass = serviceCacheData.getTargetClass();
            List<Method> methodList = serviceCacheData.getMethods();
            for (Method method : methodList) {
                String checkType;
                int type;
                Class<?>[] types = method.getParameterTypes();
                InterfaceDoc interfaceDoc = method.getAnnotation(InterfaceDoc.class);
                if (interfaceDoc == null) {
                    interfaceDoc = defInterfaceDoc;
                }
                if ((type = UriHandComponent.getType(types)) == 0) continue;
                if (interfaceDocEntity == null) {
                    interfaceDocEntity = new InterfaceDocEntity();
                    interfaceDocChildren = new ArrayList<InterfaceDocChild>();
                    String moduleName = serviceCacheData.getServiceName();
                    InterfaceModule interfaceModule = targetClass.getAnnotation(InterfaceModule.class);
                    if (interfaceModule != null && !"".equals(interfaceModule.value())) {
                        moduleName = interfaceModule.value();
                    }
                    interfaceDocEntity.setName(moduleName);
                }
                InterfaceDocChild interfaceDocChild = new InterfaceDocChild();
                String interfaceName = method.getName();
                if (!"".equals(interfaceDoc.name())) {
                    interfaceName = interfaceDoc.name();
                }
                interfaceDocChild.setName(interfaceName);
                ArrayList<InterfaceParams> interfaceParamsList = new ArrayList<InterfaceParams>();
                ArrayList<PoData> forceFields = new ArrayList<PoData>();
                Class clazz = interfaceDoc.entity();
                Class entity = null;
                Class[] checkGroups = null;
                if (clazz != EmptyClass.class) {
                    Class[] groups;
                    void var26_34;
                    checkType = "1";
                    entity = clazz;
                    Field[] fields = clazz.getDeclaredFields();
                    PoData fieldMap = PoData.create();
                    Field[] fieldArray = fields;
                    int n = fieldArray.length;
                    boolean bl = false;
                    while (var26_34 < n) {
                        Field field = fieldArray[var26_34];
                        InterfaceField ifi = field.getAnnotation(InterfaceField.class);
                        if (ifi != null) {
                            PoData fieldDescr = PoData.create().set("field", field.getName()).set("name", ifi.value()).set("descr", ifi.descr());
                            fieldMap.set(field.getName(), (Object)fieldDescr);
                        }
                        ++var26_34;
                    }
                    checkGroups = groups = interfaceDoc.groups();
                    BeanDescriptor beanDescriptor = validator.getConstraintsForClass(clazz);
                    if (beanDescriptor != null) {
                        Set set = beanDescriptor.getConstrainedProperties();
                        for (PropertyDescriptor prop : set) {
                            String field3 = prop.getPropertyName();
                            PoData fieldParam = (PoData)((Object)fieldMap.get(field3));
                            InterfaceParams ips = new InterfaceParams();
                            if (fieldParam != null) {
                                ips.setField(fieldParam.getStr("field"));
                                ips.setName(fieldParam.getStr("name"));
                                ips.setDescr(fieldParam.getStr("descr"));
                                fieldMap.remove(field3);
                            } else {
                                ips.setField(field3);
                                ips.setName("");
                                ips.setDescr("");
                            }
                            boolean forceIs = false;
                            Set cds = prop.getConstraintDescriptors();
                            for (ConstraintDescriptor cd : cds) {
                                Class<? extends Annotation> annClass = cd.getAnnotation().annotationType();
                                if (annClass != NotBlank.class && annClass != NotEmpty.class) continue;
                                Set cgroups = cd.getGroups();
                                if (cgroups.size() == 0 && groups.length == 0) {
                                    forceIs = true;
                                    break;
                                }
                                if (cgroups.contains(Default.class)) {
                                    forceIs = true;
                                    break;
                                }
                                for (Class group : groups) {
                                    if (!cgroups.contains(group)) continue;
                                    forceIs = true;
                                    break;
                                }
                                if (!forceIs) continue;
                                break;
                            }
                            ips.setForceIs(forceIs);
                            interfaceParamsList.add(ips);
                            if (!forceIs) continue;
                            PoData forceMap = PoData.create().set("field", ips.getField()).set("name", ips.getName()).set("descr", ips.getDescr());
                            forceFields.add(forceMap);
                        }
                    }
                    Set set = fieldMap.keySet();
                    for (String set2 : set) {
                        PoData fieldParam = (PoData)((Object)fieldMap.get(set2));
                        InterfaceParams ips = new InterfaceParams();
                        ips.setForceIs(false);
                        ips.setField(fieldParam.getStr("field"));
                        ips.setName(fieldParam.getStr("name"));
                        ips.setDescr(fieldParam.getStr("descr"));
                        interfaceParamsList.add(ips);
                    }
                } else {
                    checkType = "0";
                    InterfaceForm[] params = interfaceDoc.params();
                    for (InterfaceForm interfaceForm : params) {
                        InterfaceParams interfaceParams = new InterfaceParams();
                        interfaceParams.setField(interfaceForm.field());
                        interfaceParams.setName(interfaceForm.name());
                        interfaceParams.setForceIs(interfaceForm.force());
                        interfaceParams.setDescr(interfaceForm.descr());
                        if (interfaceForm.force()) {
                            PoData forceMap = PoData.create().set("field", interfaceParams.getField()).set("name", interfaceParams.getName()).set("descr", interfaceParams.getDescr());
                            forceFields.add(forceMap);
                        }
                        interfaceParamsList.add(interfaceParams);
                    }
                }
                interfaceDocChild.setParams(interfaceParamsList);
                ArrayList<String> urlList = new ArrayList<String>();
                if (type == 1) {
                    for (InterfaceForm interfaceForm : conMappings) {
                        String string = "/" + (String)((Object)interfaceForm) + "/" + serviceCacheData.getServiceName() + "/" + method.getName();
                        urlList.add(string);
                        UriMap uriMap = handMap.get(string);
                        if (uriMap == null) continue;
                        uriMap.setForceFields(forceFields);
                        uriMap.setCheckType(checkType);
                        uriMap.setEntity(entity);
                        uriMap.setGroups(checkGroups);
                    }
                } else if (type == 2) {
                    String mapKey = "/servlet/" + serviceCacheData.getServiceName() + "/" + method.getName();
                    urlList.add(mapKey);
                    UriMap uriMap = handMap.get(mapKey);
                    if (uriMap != null) {
                        uriMap.setForceFields(forceFields);
                        uriMap.setCheckType(checkType);
                        uriMap.setEntity(entity);
                        uriMap.setGroups(checkGroups);
                    }
                }
                interfaceDocChild.setUrlList(urlList);
                interfaceDocChildren.add(interfaceDocChild);
            }
            if (interfaceDocEntity == null) continue;
            interfaceDocEntity.setList(interfaceDocChildren);
            interfaceList.add(interfaceDocEntity);
        }
        interfaceCreateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    private static int getType(Class<?>[] types) {
        if (types == null || types.length == 0) {
            return 0;
        }
        if ((types.length == 1 || types.length == 2) && types[0] == PoData.class) {
            return 1;
        }
        if ((types.length == 2 || types.length == 3) && types[0] == HttpServletRequest.class && types[1] == HttpServletResponse.class) {
            return 2;
        }
        return 0;
    }

    static {
        validator = Validation.buildDefaultValidatorFactory().getValidator();
        handMap = new HashMap<String, UriMap>();
        controllerFreeProperties = new ControllerFreeProperties();
        serviceCacheDataMap = new HashMap<String, ServiceCacheData>();
    }
}

