package cn.tenfell.plugins.controllerfree.component;

import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.controllerfree.annotation.EnableControllerFree;
import cn.tenfell.plugins.controllerfree.config.ControllerFreeProperties;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

/**
 * 文档生成注册器
 * @author fs
 */
public class CtrlfreeRegistrar implements ImportBeanDefinitionRegistrar {
    @Override
    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap(annotationMetadata.getAnnotationAttributes(EnableControllerFree.class.getName()));
        ControllerFreeProperties.NeedLogin needLogin = (ControllerFreeProperties.NeedLogin)annotationAttributes.get("defaultNeedLogin");
        String password = (String)annotationAttributes.get("password");
        if(needLogin != null){
            UriHandComponent.controllerFreeProperties.setDefaultNeedLogin(needLogin);
        }
        if(StrUtil.isNotBlank(password)){
            UriHandComponent.controllerFreeProperties.setPassword(password);
        }
    }
}
