package cn.tenfell.plugins.mybatisplus.interce;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.mybatisplus.annotation.TableFieldSelect;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.*;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * @author fs
 */
@Intercepts({@Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})})
public class TableFieldSelectInterceptor implements Interceptor {
    private final static ThreadLocal<Boolean> THREAD_LOCAL = new ThreadLocal<>();
    @Override
    public Object intercept(Invocation invocation) throws Exception{
        Boolean flag = THREAD_LOCAL.get();
        if(flag == null || !flag){
            return invocation.proceed();
        }
        close();
        StatementHandler statementHandler = PluginUtils.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject(statementHandler);
        // 先判断是不是SELECT操作
        MappedStatement mappedStatement = (MappedStatement) metaObject.getValue("delegate.mappedStatement");
        if (!SqlCommandType.SELECT.equals(mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql) metaObject.getValue("delegate.boundSql");
        // 原始sql
        String originalSql = boundSql.getSql();
        String originalSqlAfter = getTableFieldSelectSql(originalSql,mappedStatement);
        if(!StrUtil.equals(originalSql,originalSqlAfter)){
            // 设置新的sql
            metaObject.setValue("delegate.boundSql.sql", originalSqlAfter);
        }
        return invocation.proceed();
    }

    private String getTableFieldSelectSql(String oldSql,MappedStatement mappedStatement){
        if(!StrUtil.startWith(oldSql,"SELECT")){
            return oldSql;
        }
        try{
            Class returnClazz =mappedStatement.getResultMaps().get(0).getType();
            Field[] fields = ReflectUtil.getFields(returnClazz);
            List<TableFieldSelect> annoList = new ArrayList<>();
            for(Field field:fields){
                TableFieldSelect fieldList =  field.getAnnotation(TableFieldSelect.class);
                if(fieldList != null){
                    annoList.add(fieldList);
                }
            }
            if(annoList.size() == 0){
                return oldSql;
            }
            for(Field field:fields){
                TableFieldSelect fieldSelect =  field.getAnnotation(TableFieldSelect.class);
                if(fieldSelect == null || StrUtil.isBlank(fieldSelect.value())){
                    continue;
                }
                String sql = fieldSelect.value();
                String fieldName = field.getName();
                String appendSql = String.format(" (%s) as %s,", sql, StrUtil.toUnderlineCase(fieldName));
                oldSql = oldSql.substring(0,6)+appendSql+oldSql.substring(6);
            }
            return oldSql;
        }catch (Exception e){
            return oldSql;
        }
    }
    public static void open(){
        THREAD_LOCAL.set(true);
    }
    public static void close(){
       THREAD_LOCAL.set(false);
    }
    /**
     * 生成拦截对象的代理
     *
     * @param target 目标对象
     * @return 代理对象
     */
    @Override
    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap(target, this);
        }
        return target;
    }

    /**
     * mybatis配置的属性
     *
     * @param properties mybatis配置的属性
     */
    @Override
    public void setProperties(Properties properties) {

    }
}
