package cn.tenfell.plugins.mybatisplus.service;

import cn.tenfell.plugins.mybatisplus.utils.MapperLoader;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class BaseService<T> {
    protected BaseMapper<T> baseMapper;
    public BaseService(){
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        final Class type = (Class) ((ParameterizedType) genericSuperclass).getActualTypeArguments()[0];
        final BaseService that = this;
        MapperLoader.asyncAction(new MapperLoader.Action() {
            @Override
            public void tdo() {
                that.baseMapper = MapperLoader.getMapper(type);
            }
        });
    }
}
