package cn.tenfell.plugins.mybatisplus.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;

import javax.tools.*;
import java.io.*;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.*;

public class ClassLoaderUtils {
    private static final Map<String,byte[]> allClassByte = new HashMap<>();
    private static final Map<String,Class> allClassList = new HashMap<>();
    public static Class compileCmd(String className,String javaCode,String classPath){
       try{
           String folder=System.getProperty("java.io.tmpdir");
           String path = folder+ SecureUtil.md5(ClassLoaderUtils.class.getResource("/").toString());
           String rootPath = new File(path).getPath();
           Runtime run = Runtime.getRuntime();
           final String fileName = className.replaceAll("\\.", "/");
           String file = rootPath+"/"+fileName+".java";
           String classFile = rootPath+"/"+fileName+".class";
           FileUtil.writeBytes(javaCode.getBytes(),file);
           Process process = run.exec("javac -encoding UTF-8 -classpath "+classPath+" -d "+rootPath+" "+file);
           String error = IoUtil.read(process.getErrorStream(),"utf-8");
           String input = IoUtil.read(process.getInputStream(),"utf-8");
           if(StrUtil.isBlank(error)){
               byte[] data = FileUtil.readBytes(classFile);
               allClassByte.put(fileName, data);
               return loadClass(className,data);
           }
       }catch (Exception e){
           e.printStackTrace();
       }
        return null;
    }
    public static Class compile(String className,final String javaCode,String classPath){
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if(compiler == null){
            return compileCmd(className,javaCode,classPath);
        }
        final String fileName = className.replaceAll("\\.", "/");
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null,                 null, null);
        JavaFileManager jfm = new ForwardingJavaFileManager(fileManager) {
            @Override
            public JavaFileObject getJavaFileForOutput(Location location,
                                                       String className,
                                                       JavaFileObject.Kind kind,
                                                       FileObject sibling) throws IOException {
                if(kind == JavaFileObject.Kind.CLASS) {
                    return new SimpleJavaFileObject(URI.create(className + ".class"), JavaFileObject.Kind.CLASS) {
                        @Override
                        public OutputStream openOutputStream() {
                            return new FilterOutputStream(new ByteArrayOutputStream()) {
                                @Override
                                public void close() throws IOException{
                                    out.close();
                                    ByteArrayOutputStream bos = (ByteArrayOutputStream) out;
                                    allClassByte.put(fileName, bos.toByteArray());
                                }
                            };
                        }
                    };
                }else{
                    return super.getJavaFileForOutput(location, className, kind, sibling);
                }
            }
        };
        SimpleJavaFileObject srcObject = new SimpleJavaFileObject(URI.create(fileName+".java"),
                JavaFileObject.Kind.SOURCE){
            @Override
            public CharBuffer getCharContent(boolean b) {
                return CharBuffer.wrap(javaCode);
            }
        };
        List<String> tempOptions = new ArrayList<>();
        tempOptions.add("-encoding");
        tempOptions.add("UTF-8");
        if(StrUtil.isNotBlank(classPath)){
            tempOptions.add("-classpath");
            tempOptions.add(classPath);
        }
        Iterable<String> options = tempOptions;
        Iterable<? extends JavaFileObject> fileObjects = Arrays.asList(srcObject);
        JavaCompiler.CompilationTask task = compiler.getTask(null, jfm, null, options, null, fileObjects);
        try{
            boolean result = task.call();
            if (result == true) {
                byte[] data = allClassByte.get(fileName);
                return loadClass(className,data);
            }
        }catch (Exception e){
            return compileCmd(className,javaCode,classPath);
        }
        return null;
    }
    private static Class loadClass(String className,byte[] data){
        if(allClassList.get(className) != null){
            return allClassList.get(className);
        }
        try{
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class clazz =  ReflectUtil.invoke(classLoader,"defineClass",className,data,0,data.length);
            allClassList.put(className,clazz);
        }catch (Exception e){
            e.printStackTrace();
        }
        return allClassList.get(className);
    }
}
