package cn.tenfell.plugins.mybatisplus.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.crypto.SecureUtil;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.mybatis.spring.SqlSessionTemplate;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.*;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MapperLoader {
    //private static String classPath;
    private static List<String> classPaths = new ArrayList<>();
    private static List<String> classPathChecks = new ArrayList<>();
    public static SqlSessionTemplate sqlSessionTemplate;
    private static final HashMap<Class,Class> classMap = new HashMap<>();
    private static final List<Action> needInitList = new ArrayList<>();
    private static Class getMapperClass(Class entity){
        if(classMap.get(entity) != null){
            return classMap.get(entity);
        }
        try{
            TableInfo tableInfo = SqlHelper.table(entity);
            return Class.forName(tableInfo.getCurrentNamespace());
        }catch (Exception e){

        }
        String packageName = entity.getPackage().getName();
        String simpleMapperName = entity.getSimpleName()+"Mapper";
        String javaCode = "package "+packageName+";public interface "+simpleMapperName+" extends "+ BaseMapper.class.getName() +"<"+entity.getName()+">{}";
        String className = packageName+"."+simpleMapperName;
        initClassPath(entity);
        Class<?> mapperClass = ClassLoaderUtils.compile(className,javaCode,CollUtil.join(classPaths,File.pathSeparator));
        classMap.put(entity,mapperClass);
        return classMap.get(entity);
    }
    private static void initClassPath(Class entity){
        URL localUrl = MapperLoader.class.getResource("/");
        String folder=System.getProperty("java.io.tmpdir");
        String path = folder+ SecureUtil.md5(localUrl.toString())+File.separator;
        try{
            if(!classPathChecks.contains(localUrl.getPath())){
                //处理spring boot当前的classes
                String localPath = "";
                if("jar".equals(localUrl.getProtocol())){
                    JarURLConnection conn = (JarURLConnection)localUrl.openConnection();
                    JarFile jarFile = conn.getJarFile();
                    Enumeration<JarEntry> entries =  jarFile.entries();
                    while (entries.hasMoreElements()){
                        JarEntry jarEntry = entries.nextElement();
                        if(jarEntry.getName().endsWith(".class")){
                            FileUtil.writeFromStream(URLUtil.url(localUrl.toString()+jarEntry.getName()).openStream(),path+jarEntry.getName());
                        }
                    }
                    localPath = path;
                }else{
                    localPath = new File(localUrl.getPath()).getPath();
                }
                classPaths.add(localPath);
                classPathChecks.add(localUrl.getPath());
            }
            //处理实体不在当前classes,而是在第三方包的情况
            initClassPathByEntity(entity,path);
            //处理BaseMapper所在第三方包的情况
            initClassPathByEntity(BaseMapper.class,path);
        }catch (Exception e){
            e.printStackTrace();
        }
    }
    private static void initClassPathByEntity(Class clazz,String path) throws Exception{
        URL baseUrl = clazz.getResource("");
        if("jar".equals(baseUrl.getProtocol())){
            JarURLConnection conn = (JarURLConnection)baseUrl.openConnection();
            String temp = conn.getJarFileURL().getPath();
            if(!classPathChecks.contains(temp)){
                String filePath = path+new File(temp).getName();
                FileUtil.writeFromStream(conn.getJarFileURL().openStream(),filePath);
                classPaths.add(filePath);
                classPathChecks.add(temp);
            }
        }else{
            baseUrl = clazz.getProtectionDomain().getCodeSource().getLocation();
            String basePath = new File(baseUrl.getPath()).getPath();
            if(!classPathChecks.contains(basePath)){
                classPaths.add(basePath);
                classPathChecks.add(basePath);
            }
        }
    }
    private static void addMapper(Class entity){
        sqlSessionTemplate.getConfiguration().addMapper(getMapperClass(entity));
    }
    public static <T> T getMapper(Class entity){
        Object obj;
        try{
            obj = sqlSessionTemplate.getMapper(getMapperClass(entity));
        }catch (Exception e){
            addMapper(entity);
            obj = sqlSessionTemplate.getMapper(getMapperClass(entity));
        }
        return (T)obj;
    }
    public static void asyncAction(Action action){
        if(MapperLoader.sqlSessionTemplate == null){
            MapperLoader.needInitList.add(action);
        }else{
            action.tdo();
        }
    }
    public static void init(SqlSessionTemplate sqlSession){
        MapperLoader.sqlSessionTemplate = sqlSession;
        if(MapperLoader.needInitList.size()>0){
            Iterator<Action> it=MapperLoader.needInitList.iterator();
            while(it.hasNext()){
                it.next().tdo();
                it.remove();
            }
        }
    }
    public interface Action{
        void tdo();
    }
}
