/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.mybatisplus.interce;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.mybatisplus.annotation.TableFieldChildren;
import cn.tenfell.plugins.mybatisplus.annotation.TableFieldChildrenMap;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.SqlSession;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class TableFieldChildrenInterceptor
implements Interceptor {
    private static final ThreadLocal<Boolean> THREAD_LOCAL = new ThreadLocal();

    public Object intercept(Invocation invocation) throws Exception {
        Boolean flag = THREAD_LOCAL.get();
        if (flag == null || !flag.booleanValue()) {
            return invocation.proceed();
        }
        TableFieldChildrenInterceptor.close();
        List list = (List)invocation.proceed();
        if (list == null || list.size() == 0) {
            return list;
        }
        ResultSetHandler resultSetHandler = (ResultSetHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)resultSetHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("mappedStatement");
        Class returnClazz = ((ResultMap)mappedStatement.getResultMaps().get(0)).getType();
        Field[] fields = ReflectUtil.getFields((Class)returnClazz);
        ArrayList<TableFieldChildren> annoList = new ArrayList<TableFieldChildren>();
        for (Field field : fields) {
            TableFieldChildren fieldList = field.getAnnotation(TableFieldChildren.class);
            if (fieldList == null) continue;
            annoList.add(fieldList);
        }
        if (annoList.size() == 0) {
            return list;
        }
        ArrayList<SqlMapData> sqlMapList = new ArrayList<SqlMapData>();
        for (Field field : fields) {
            TableFieldChildren fieldList = field.getAnnotation(TableFieldChildren.class);
            if (fieldList == null) continue;
            String sql = fieldList.sql();
            TableFieldChildrenMap[] keyMaps = fieldList.keys();
            TableFieldChildrenMap[] clazz = fieldList.clazz();
            if (StrUtil.isBlank((CharSequence)sql) || keyMaps.length == 0 || clazz == Object.class) continue;
            TableInfo tableInfo = SqlHelper.table((Class)clazz);
            SqlMapData sqlMap = new SqlMapData();
            sqlMap.setFieldName(field.getName());
            sqlMap.setKeyMaps(keyMaps);
            sqlMap.setSql(sql);
            sqlMap.setTableInfo(tableInfo);
            sqlMap.setSqlSession(SqlHelper.sqlSession((Class)tableInfo.getEntityType()));
            sqlMapList.add(sqlMap);
        }
        for (SqlMapData value : sqlMapList) {
            TableFieldChildrenMap[] keyMaps = value.getKeyMaps();
            String fieldName = value.getFieldName();
            for (Object obj : list) {
                if (obj == null) continue;
                StringBuilder sb = new StringBuilder("where");
                for (TableFieldChildrenMap keyMap : keyMaps) {
                    sb.append(" ").append(StrUtil.toUnderlineCase((CharSequence)keyMap.childField())).append("='").append(Convert.toStr((Object)ReflectUtil.getFieldValue(obj, (String)keyMap.parentField()))).append("' and");
                }
                sb.append(" ").append(value.getSql());
                String lastSql = sb.toString();
                List data = this.getChildren(lastSql, value.getTableInfo(), value.getSqlSession());
                Class<List> fieldType = ReflectUtil.getField(obj.getClass(), (String)fieldName).getType();
                if (fieldType.isAssignableFrom(List.class)) {
                    ReflectUtil.setFieldValue(obj, (String)fieldName, (Object)data);
                    continue;
                }
                if (fieldType == value.getTableInfo().getEntityType() && data.size() <= 1) {
                    if (data.size() == 1) {
                        ReflectUtil.setFieldValue(obj, (String)fieldName, data.get(0));
                        continue;
                    }
                    ReflectUtil.setFieldValue(obj, (String)fieldName, null);
                    continue;
                }
                Console.error((String)"\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u6ce8\u5165:{}", (Object[])new Object[]{fieldType.toString()});
            }
            value.getSqlSession().close();
        }
        return list;
    }

    private List getChildren(String lastSql, TableInfo tableInfo, SqlSession sqlSession) {
        MapperMethod.ParamMap paramMap = new MapperMethod.ParamMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.last(lastSql);
        paramMap.put((Object)"ew", (Object)queryWrapper);
        List list = sqlSession.selectList(tableInfo.getCurrentNamespace() + ".selectList", (Object)paramMap);
        return list;
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    public static void open() {
        THREAD_LOCAL.set(true);
    }

    public static void close() {
        THREAD_LOCAL.set(false);
    }

    public class SqlMapData {
        private String fieldName;
        private String sql;
        private TableInfo tableInfo;
        private SqlSession sqlSession;
        private TableFieldChildrenMap[] keyMaps;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public TableInfo getTableInfo() {
            return this.tableInfo;
        }

        public void setTableInfo(TableInfo tableInfo) {
            this.tableInfo = tableInfo;
        }

        public SqlSession getSqlSession() {
            return this.sqlSession;
        }

        public void setSqlSession(SqlSession sqlSession) {
            this.sqlSession = sqlSession;
        }

        public TableFieldChildrenMap[] getKeyMaps() {
            return this.keyMaps;
        }

        public void setKeyMaps(TableFieldChildrenMap[] keyMaps) {
            this.keyMaps = keyMaps;
        }
    }
}

