/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.mybatisplus.interce;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.mybatisplus.annotation.TableFieldSelect;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class TableFieldSelectInterceptor
implements Interceptor {
    private static final ThreadLocal<Boolean> THREAD_LOCAL = new ThreadLocal();

    public Object intercept(Invocation invocation) throws Exception {
        String originalSqlAfter;
        Boolean flag = THREAD_LOCAL.get();
        if (flag == null || !flag.booleanValue()) {
            return invocation.proceed();
        }
        TableFieldSelectInterceptor.close();
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (!SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        String originalSql = boundSql.getSql();
        if (!StrUtil.equals((CharSequence)originalSql, (CharSequence)(originalSqlAfter = this.getTableFieldSelectSql(originalSql, mappedStatement)))) {
            metaObject.setValue("delegate.boundSql.sql", (Object)originalSqlAfter);
        }
        return invocation.proceed();
    }

    private String getTableFieldSelectSql(String oldSql, MappedStatement mappedStatement) {
        if (!StrUtil.startWith((CharSequence)oldSql, (CharSequence)"SELECT")) {
            return oldSql;
        }
        try {
            Class returnClazz = ((ResultMap)mappedStatement.getResultMaps().get(0)).getType();
            Field[] fields = ReflectUtil.getFields((Class)returnClazz);
            ArrayList<TableFieldSelect> annoList = new ArrayList<TableFieldSelect>();
            for (Field field : fields) {
                TableFieldSelect fieldList = field.getAnnotation(TableFieldSelect.class);
                if (fieldList == null) continue;
                annoList.add(fieldList);
            }
            if (annoList.size() == 0) {
                return oldSql;
            }
            for (Field field : fields) {
                TableFieldSelect fieldSelect = field.getAnnotation(TableFieldSelect.class);
                if (fieldSelect == null || StrUtil.isBlank((CharSequence)fieldSelect.value())) continue;
                String sql = fieldSelect.value();
                String fieldName = field.getName();
                String appendSql = String.format(" (%s) as %s,", sql, StrUtil.toUnderlineCase((CharSequence)fieldName));
                oldSql = oldSql.substring(0, 6) + appendSql + oldSql.substring(6);
            }
            return oldSql;
        }
        catch (Exception e) {
            return oldSql;
        }
    }

    public static void open() {
        THREAD_LOCAL.set(true);
    }

    public static void close() {
        THREAD_LOCAL.set(false);
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

