/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.mybatisplus.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class ClassLoaderUtils {
    private static final Map<String, byte[]> allClassByte = new HashMap<String, byte[]>();
    private static final Map<String, Class> allClassList = new HashMap<String, Class>();

    public static Class compileCmd(String className, String javaCode, String classPath) {
        try {
            String folder = System.getProperty("java.io.tmpdir");
            String path = folder + SecureUtil.md5((String)ClassLoaderUtils.class.getResource("/").toString());
            String rootPath = new File(path).getPath();
            Runtime run = Runtime.getRuntime();
            String fileName = className.replaceAll("\\.", "/");
            String file = rootPath + "/" + fileName + ".java";
            String classFile = rootPath + "/" + fileName + ".class";
            FileUtil.writeBytes((byte[])javaCode.getBytes(), (String)file);
            Process process = run.exec("javac -encoding UTF-8 -classpath " + classPath + " -d " + rootPath + " " + file);
            String error = IoUtil.read((InputStream)process.getErrorStream(), (String)"utf-8");
            String input = IoUtil.read((InputStream)process.getInputStream(), (String)"utf-8");
            if (StrUtil.isBlank((CharSequence)error)) {
                byte[] data = FileUtil.readBytes((String)classFile);
                allClassByte.put(fileName, data);
                return ClassLoaderUtils.loadClass(className, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Class compile(String className, final String javaCode, String classPath) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            return ClassLoaderUtils.compileCmd(className, javaCode, classPath);
        }
        final String fileName = className.replaceAll("\\.", "/");
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        ForwardingJavaFileManager jfm = new ForwardingJavaFileManager(fileManager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                if (kind == JavaFileObject.Kind.CLASS) {
                    return new SimpleJavaFileObject(URI.create(className + ".class"), JavaFileObject.Kind.CLASS){

                        @Override
                        public OutputStream openOutputStream() {
                            return new FilterOutputStream(new ByteArrayOutputStream()){

                                @Override
                                public void close() throws IOException {
                                    this.out.close();
                                    ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                                    allClassByte.put(fileName, bos.toByteArray());
                                }
                            };
                        }
                    };
                }
                return super.getJavaFileForOutput(location, className, kind, sibling);
            }
        };
        SimpleJavaFileObject srcObject = new SimpleJavaFileObject(URI.create(fileName + ".java"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharBuffer getCharContent(boolean b) {
                return CharBuffer.wrap(javaCode);
            }
        };
        ArrayList<String> tempOptions = new ArrayList<String>();
        tempOptions.add("-encoding");
        tempOptions.add("UTF-8");
        if (StrUtil.isNotBlank((CharSequence)classPath)) {
            tempOptions.add("-classpath");
            tempOptions.add(classPath);
        }
        ArrayList<String> options = tempOptions;
        List<SimpleJavaFileObject> fileObjects = Arrays.asList(srcObject);
        JavaCompiler.CompilationTask task = compiler.getTask(null, jfm, null, options, null, fileObjects);
        try {
            boolean result = task.call();
            if (result) {
                byte[] data = allClassByte.get(fileName);
                return ClassLoaderUtils.loadClass(className, data);
            }
        }
        catch (Exception e) {
            return ClassLoaderUtils.compileCmd(className, javaCode, classPath);
        }
        return null;
    }

    private static Class loadClass(String className, byte[] data) {
        if (allClassList.get(className) != null) {
            return allClassList.get(className);
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class clazz = (Class)ReflectUtil.invoke((Object)classLoader, (String)"defineClass", (Object[])new Object[]{className, data, 0, data.length});
            allClassList.put(className, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allClassList.get(className);
    }
}

