/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.mybatisplus.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.crypto.SecureUtil;
import cn.tenfell.plugins.mybatisplus.utils.ClassLoaderUtils;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.mybatis.spring.SqlSessionTemplate;

public class MapperLoader {
    private static List<String> classPaths = new ArrayList<String>();
    private static List<String> classPathChecks = new ArrayList<String>();
    public static SqlSessionTemplate sqlSessionTemplate;
    private static final HashMap<Class, Class> classMap;
    private static final List<Action> needInitList;

    private static Class getMapperClass(Class entity) {
        if (classMap.get(entity) != null) {
            return classMap.get(entity);
        }
        try {
            TableInfo tableInfo = SqlHelper.table((Class)entity);
            return Class.forName(tableInfo.getCurrentNamespace());
        }
        catch (Exception tableInfo) {
            String packageName = entity.getPackage().getName();
            String simpleMapperName = entity.getSimpleName() + "Mapper";
            String javaCode = "package " + packageName + ";public interface " + simpleMapperName + " extends " + BaseMapper.class.getName() + "<" + entity.getName() + ">{}";
            String className = packageName + "." + simpleMapperName;
            MapperLoader.initClassPath(entity);
            Class mapperClass = ClassLoaderUtils.compile(className, javaCode, CollUtil.join(classPaths, (CharSequence)File.pathSeparator));
            classMap.put(entity, mapperClass);
            return classMap.get(entity);
        }
    }

    private static void initClassPath(Class entity) {
        URL localUrl = MapperLoader.class.getResource("/");
        String folder = System.getProperty("java.io.tmpdir");
        String path = folder + SecureUtil.md5((String)localUrl.toString()) + File.separator;
        try {
            if (!classPathChecks.contains(localUrl.getPath())) {
                String localPath = "";
                if ("jar".equals(localUrl.getProtocol())) {
                    JarURLConnection conn = (JarURLConnection)localUrl.openConnection();
                    JarFile jarFile = conn.getJarFile();
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        if (!jarEntry.getName().endsWith(".class")) continue;
                        FileUtil.writeFromStream((InputStream)URLUtil.url((String)(localUrl.toString() + jarEntry.getName())).openStream(), (String)(path + jarEntry.getName()));
                    }
                    localPath = path;
                } else {
                    localPath = new File(localUrl.getPath()).getPath();
                }
                classPaths.add(localPath);
                classPathChecks.add(localUrl.getPath());
            }
            MapperLoader.initClassPathByEntity(entity, path);
            MapperLoader.initClassPathByEntity(BaseMapper.class, path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initClassPathByEntity(Class clazz, String path) throws Exception {
        URL baseUrl = clazz.getResource("");
        if ("jar".equals(baseUrl.getProtocol())) {
            JarURLConnection conn = (JarURLConnection)baseUrl.openConnection();
            String temp = conn.getJarFileURL().getPath();
            if (!classPathChecks.contains(temp)) {
                String filePath = path + new File(temp).getName();
                FileUtil.writeFromStream((InputStream)conn.getJarFileURL().openStream(), (String)filePath);
                classPaths.add(filePath);
                classPathChecks.add(temp);
            }
        } else {
            baseUrl = clazz.getProtectionDomain().getCodeSource().getLocation();
            String basePath = new File(baseUrl.getPath()).getPath();
            if (!classPathChecks.contains(basePath)) {
                classPaths.add(basePath);
                classPathChecks.add(basePath);
            }
        }
    }

    private static void addMapper(Class entity) {
        sqlSessionTemplate.getConfiguration().addMapper(MapperLoader.getMapperClass(entity));
    }

    public static <T> T getMapper(Class entity) {
        Object obj;
        try {
            obj = sqlSessionTemplate.getMapper(MapperLoader.getMapperClass(entity));
        }
        catch (Exception e) {
            MapperLoader.addMapper(entity);
            obj = sqlSessionTemplate.getMapper(MapperLoader.getMapperClass(entity));
        }
        return (T)obj;
    }

    public static void asyncAction(Action action) {
        if (sqlSessionTemplate == null) {
            needInitList.add(action);
        } else {
            action.tdo();
        }
    }

    public static void init(SqlSessionTemplate sqlSession) {
        sqlSessionTemplate = sqlSession;
        if (needInitList.size() > 0) {
            Iterator<Action> it = needInitList.iterator();
            while (it.hasNext()) {
                it.next().tdo();
                it.remove();
            }
        }
    }

    static {
        classMap = new HashMap();
        needInitList = new ArrayList<Action>();
    }

    public static interface Action {
        public void tdo();
    }
}

