/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.mybatisplus.interce;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Console;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class TableChildrenSelectInterceptor
implements Interceptor {
    private static final ThreadLocal<String> SQL_SELECT = new ThreadLocal();
    private static final ThreadLocal<String> PARENT_FIELD = new ThreadLocal();

    public static void set(String sql, String parentField) {
        SQL_SELECT.set(sql);
        PARENT_FIELD.set(parentField);
    }

    private static String getSql() {
        return SQL_SELECT.get();
    }

    private static String getParentField() {
        return PARENT_FIELD.get();
    }

    private static Object handler(Invocation invocation) throws InvocationTargetException, IllegalAccessException {
        if (StrUtil.isNotBlank((CharSequence)TableChildrenSelectInterceptor.getSql())) {
            SQL_SELECT.remove();
        }
        if (StrUtil.isNotBlank((CharSequence)TableChildrenSelectInterceptor.getParentField())) {
            PARENT_FIELD.remove();
        }
        return invocation.proceed();
    }

    private static Object handler(List list) {
        if (StrUtil.isNotBlank((CharSequence)TableChildrenSelectInterceptor.getSql())) {
            SQL_SELECT.remove();
        }
        if (StrUtil.isNotBlank((CharSequence)TableChildrenSelectInterceptor.getParentField())) {
            PARENT_FIELD.remove();
        }
        return list;
    }

    public Object intercept(Invocation invocation) throws Exception {
        String sql = TableChildrenSelectInterceptor.getSql();
        if (StrUtil.isBlank((CharSequence)sql)) {
            return TableChildrenSelectInterceptor.handler(invocation);
        }
        List list = (List)invocation.proceed();
        if (list == null || list.size() == 0) {
            return TableChildrenSelectInterceptor.handler(list);
        }
        String parentField = TableChildrenSelectInterceptor.getParentField();
        Field field = ReflectUtil.getField(list.get(0).getClass(), (String)parentField);
        Class childType = field.getType();
        Class<?> fieldType = field.getType();
        if (ClassUtil.isAssignable(Iterable.class, fieldType)) {
            Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            childType = (Class)types[0];
        }
        Configuration configuration = SqlHelper.sqlSessionFactory(childType).getConfiguration();
        Environment environment = (Environment)ReflectUtil.getFieldValue((Object)configuration, (String)"environment");
        DataSource dataSource = (DataSource)ReflectUtil.getFieldValue((Object)environment, (String)"dataSource");
        for (Object obj : list) {
            if (obj == null) continue;
            List data = this.getChildren(obj, sql, childType, dataSource);
            if (ClassUtil.isAssignable(Iterable.class, fieldType)) {
                ReflectUtil.setFieldValue(obj, (String)parentField, (Object)data);
                continue;
            }
            if (fieldType == childType && data.size() <= 1) {
                if (data.size() == 1) {
                    ReflectUtil.setFieldValue(obj, (String)parentField, data.get(0));
                    continue;
                }
                ReflectUtil.setFieldValue(obj, (String)parentField, null);
                continue;
            }
            Console.error((String)"\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u6ce8\u5165:{}", (Object[])new Object[]{fieldType.toString()});
        }
        return TableChildrenSelectInterceptor.handler(list);
    }

    private List<Dict> getColumns(Class clazz) {
        HashMap<String, String> columnMaps = new HashMap<String, String>();
        try {
            TableInfo tableInfo = SqlHelper.table((Class)clazz);
            columnMaps.put(tableInfo.getKeyColumn(), tableInfo.getKeyProperty());
            List tableFieldInfos = tableInfo.getFieldList();
            Iterator iterator = tableFieldInfos.iterator();
            while (iterator.hasNext()) {
                TableFieldInfo tableFieldInfo = (TableFieldInfo)iterator.next();
                columnMaps.put(tableFieldInfo.getColumn(), tableFieldInfo.getProperty());
            }
        }
        catch (Exception tableInfo) {
            // empty catch block
        }
        Field[] fields = ReflectUtil.getFields((Class)clazz);
        for (Field field : fields) {
            String property = field.getName();
            String column = StrUtil.toUnderlineCase((CharSequence)property);
            if (columnMaps.get(column) != null) continue;
            columnMaps.put(column, property);
        }
        final ArrayList<Dict> list = new ArrayList<Dict>();
        CollUtil.forEach(columnMaps, (CollUtil.KVConsumer)new CollUtil.KVConsumer<String, String>(){

            public void accept(String key, String val, int i) {
                list.add(Dict.create().set("column", (Object)key).set("property", (Object)val));
            }
        });
        return list;
    }

    private List getChildren(Object parent, String sql, Class child, DataSource dataSource) throws SQLException {
        int s;
        TableInfo parentInfo = SqlHelper.table(parent.getClass());
        List<Dict> parentColList = this.getColumns(parent.getClass());
        String parentTable = parentInfo.getTableName();
        String tempSql = " " + sql + " ";
        block0: while ((s = tempSql.indexOf(parentTable + ".")) != -1) {
            int e = tempSql.indexOf(" ", s + 1);
            String key = tempSql.substring(s, e);
            for (Dict parentCol : parentColList) {
                String column = parentCol.getStr("column");
                String property = parentCol.getStr("property");
                if (!StrUtil.equals((CharSequence)(parentTable + "." + column), (CharSequence)key)) continue;
                String value = ReflectUtil.getFieldValue((Object)parent, (String)property).toString();
                tempSql = tempSql.replace(key, "'" + value + "'");
                continue block0;
            }
        }
        String runSql = tempSql.trim();
        List list = Db.use((DataSource)dataSource).query(runSql, new Object[0]);
        ArrayList<Object> res = new ArrayList<Object>();
        for (Entity entity : list) {
            res.add(entity.toBean(child));
        }
        return res;
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

