/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.mybatisplus.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.mybatisplus.entity.ChildrenSelect;
import cn.tenfell.plugins.mybatisplus.entity.FieldSelect;
import cn.tenfell.plugins.mybatisplus.interce.TableChildrenSelectInterceptor;
import cn.tenfell.plugins.mybatisplus.interce.TableFieldSelectInterceptor;
import cn.tenfell.plugins.mybatisplus.utils.MapperLoaderUtils;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.ibatis.reflection.property.PropertyNamer;

public class MapperUtils {
    private static String getFieldName(SFunction sFunction) {
        String fieldName = PropertyNamer.methodToProperty((String)LambdaUtils.resolve((SFunction)sFunction).getImplMethodName());
        return fieldName;
    }

    public static String getUnderlineName(SFunction column) {
        return StringUtils.camelToUnderline((String)MapperUtils.getFieldName(column));
    }

    public static void selectField(String sql) {
        if (StrUtil.isBlank((CharSequence)sql)) {
            return;
        }
        TableFieldSelectInterceptor.add(sql);
    }

    public static <T extends BaseMapper<E>, E> T getMapper(Class<E> entity) {
        return MapperLoaderUtils.getMapper(entity);
    }

    public static <T extends BaseMapper<E>, E> void asyncGetMapper(final Class<E> entity, final Consumer<T> consumer) {
        MapperLoaderUtils.asyncAction(new MapperLoaderUtils.Action(){

            @Override
            public void tdo() {
                consumer.accept(MapperUtils.getMapper(entity));
            }
        });
    }

    public static <P, C> void selectField(FieldSelect<P, C> fieldSelectMap) {
        if (fieldSelectMap == null) {
            return;
        }
        FieldSelect.FieldSelectData data = fieldSelectMap.getData();
        Class parentCls = data.getParentCls();
        Class childCls = data.getChildCls();
        SFunction parentFld = data.getParentFld();
        String childCol = data.getChildColumn();
        List parentKeys = data.getParentKeys();
        List childKeys = data.getChildKeys();
        Assert.notNull(parentCls, (String)"init param\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(childCls, (String)"from param\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(parentFld, (String)"as param\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)childCol, (String)"select param\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((parentKeys.size() > 0 && childKeys.size() > 0 && parentKeys.size() == childKeys.size() ? 1 : 0) != 0, (String)"whereOrAnd param\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        String parentCol = MapperUtils.getUnderlineName(parentFld);
        String parentTab = SqlHelper.table(parentCls).getTableName();
        String childTab = SqlHelper.table(childCls).getTableName();
        String mapSql = "";
        String lastSql = StrUtil.isBlank((CharSequence)data.getChildLastSql()) ? "" : data.getChildLastSql();
        for (int i = 0; i < parentKeys.size(); ++i) {
            if (i > 0) {
                mapSql = mapSql + " AND ";
            }
            SFunction parentKey = parentKeys.get(i);
            SFunction childKey = childKeys.get(i);
            mapSql = mapSql + MapperUtils.getUnderlineName(childKey) + " = " + parentTab + "." + MapperUtils.getUnderlineName(parentKey);
        }
        String sql = "( SELECT " + childCol + " FROM " + childTab + " WHERE " + mapSql + " " + lastSql + " ) AS " + parentCol;
        MapperUtils.selectField(sql);
    }

    public static <P, C> void selectChildren(ChildrenSelect<P, C> childrenSelect, SFunction<P, ?> parentField) {
        if (childrenSelect == null) {
            return;
        }
        ChildrenSelect.ChildrenSelectData data = childrenSelect.getData();
        Class parentCls = data.getParentCls();
        Class childCls = data.getChildCls();
        List parentKeys = data.getParentKeys();
        List childKeys = data.getChildKeys();
        Assert.notNull(parentCls, (String)"init param\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(childCls, (String)"from param\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((parentKeys.size() > 0 && childKeys.size() > 0 && parentKeys.size() == childKeys.size() ? 1 : 0) != 0, (String)"whereOrAnd param\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        String parentFieldStr = MapperUtils.getFieldName(parentField);
        TableInfo childInfo = SqlHelper.table(childCls);
        String childTab = childInfo.getTableName();
        List<String> childCols = data.getChildCols();
        if (childCols == null || childCols.size() == 0) {
            if (childCols == null) {
                childCols = new ArrayList<String>();
            }
            childCols.add(childInfo.getKeyColumn());
            List fields = childInfo.getFieldList();
            for (TableFieldInfo field : fields) {
                childCols.add(field.getColumn());
            }
        }
        String childColsStr = CollUtil.join(childCols, (CharSequence)",");
        String mapSql = "";
        String lastSql = StrUtil.isBlank((CharSequence)data.getChildLastSql()) ? "" : data.getChildLastSql();
        String parentTab = SqlHelper.table(parentCls).getTableName();
        for (int i = 0; i < parentKeys.size(); ++i) {
            if (i > 0) {
                mapSql = mapSql + " AND ";
            }
            SFunction parentKey = parentKeys.get(i);
            SFunction childKey = childKeys.get(i);
            mapSql = mapSql + MapperUtils.getUnderlineName(childKey) + " = " + parentTab + "." + MapperUtils.getUnderlineName(parentKey);
        }
        String sql = "SELECT " + childColsStr + " FROM " + childTab + " WHERE " + mapSql + " " + lastSql;
        MapperUtils.selectChildren(sql, parentFieldStr);
    }

    public static void selectChildren(String sql, String parentField) {
        if (StrUtil.isBlank((CharSequence)sql)) {
            return;
        }
        TableChildrenSelectInterceptor.set(sql, parentField);
    }
}

