package cn.tenfell.plugins.mybatisplus.component;

import cn.tenfell.plugins.mybatisplus.utils.MapperLoaderUtils;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
@Component
public class NoMapperComponent implements ApplicationContextAware {
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String[] names = applicationContext.getBeanNamesForType(SqlSessionTemplate.class);
        SqlSessionTemplate sqlSessionTemplate = null;
        for(String name:names){
            Object temp = applicationContext.getBean(name, SqlSessionTemplate.class);
            sqlSessionTemplate = (SqlSessionTemplate)temp;
            break;
        }
        MapperLoaderUtils.init(sqlSessionTemplate);
    }
}

