package cn.tenfell.plugins.mybatisplus.entity;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.tenfell.plugins.mybatisplus.utils.MapperUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import lombok.Data;
import lombok.NonNull;

import java.util.ArrayList;
import java.util.List;
public class FieldSelect<P,C>{
    private FieldSelectData<P,C> data;
    public FieldSelect(){
        this.data = new FieldSelectData<>();
        this.data.setParentKeys(new ArrayList<>());
        this.data.setChildKeys(new ArrayList<>());
    }
    public FieldSelect<P,C> init(@NonNull Class<P> parentCls){
        this.data.setParentCls(parentCls);
        return this;
    }
    public FieldSelect<P,C> select(@NonNull SFunction<C,?> childFld){
        this.select(MapperUtils.getUnderlineName(childFld));
        return this;
    }
    public FieldSelect<P,C> select(@NonNull String column){
        this.data.setChildColumn(column);
        return this;
    }
    public FieldSelect<P,C> from(@NonNull Class<C> childCls){
        this.data.setChildCls(childCls);
        return this;
    }
    public FieldSelect<P,C> whereOrAnd(@NonNull SFunction<C,?> childKey,@NonNull SFunction<P,?> parentKey){
        Class parentCls = this.data.getParentCls();
        Assert.notNull(parentCls,"init param不可为空");
        String parentTab = SqlHelper.table(parentCls).getTableName();
        String column = MapperUtils.getUnderlineName(childKey);
        String value = MapperUtils.getUnderlineName(parentKey);
        return whereOrAnd(column,parentTab+"."+value,false);
    }
    public FieldSelect<P,C> whereOrAnd(@NonNull SFunction<C,?> childKey,@NonNull Object value){
        return whereOrAnd(MapperUtils.getUnderlineName(childKey),value);
    }
    public FieldSelect<P,C> whereOrAnd(@NonNull String column,@NonNull Object value){
        return whereOrAnd(column,value,true);
    }
    private FieldSelect<P,C> whereOrAnd(@NonNull String column,@NonNull Object value,boolean needYh){
        this.data.getChildKeys().add(column);
        String val = Convert.toStr(value);
        if(value == null){
            val = "";
        }
        if(needYh){
            val = "'"+val+"'";
        }
        this.data.getParentKeys().add(val);
        return this;
    }
    public FieldSelect<P,C> last(String lastSql){
        this.data.setChildLastSql(lastSql);
        return this;
    }
    public FieldSelect<P,C> as(@NonNull SFunction<P,?> parentFld){
        this.data.setParentFld(parentFld);
        return this;
    }
    public FieldSelectData getData(){
        return this.data;
    }
    @Data
    public static class FieldSelectData<P,C>{
        private Class<P> parentCls;
        private Class<C> childCls;
        private SFunction<P,?> parentFld;
        private String childColumn;
        private String childLastSql;
        private List<String> parentKeys;
        private List<String> childKeys;
    }
}
