package cn.tenfell.plugins.mybatisplus.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.mybatisplus.entity.ChildrenSelect;
import cn.tenfell.plugins.mybatisplus.entity.FieldSelect;
import cn.tenfell.plugins.mybatisplus.interce.TableChildrenSelectInterceptor;
import cn.tenfell.plugins.mybatisplus.interce.TableFieldSelectInterceptor;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.apache.ibatis.reflection.property.PropertyNamer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class MapperUtils {
    private static String getFieldName(SFunction sFunction){
        String fieldName = PropertyNamer.methodToProperty(LambdaUtils.resolve(sFunction).getImplMethodName());
        return fieldName;
    }
    public static String getUnderlineName(SFunction column){
        return StringUtils.camelToUnderline(getFieldName(column));
    }
    public static void selectField(String sql){
        if(StrUtil.isBlank(sql)){
            return;
        }
        TableFieldSelectInterceptor.add(sql);
    }
    public static <T extends BaseMapper<E>,E> T getMapper(Class<E> entity){
        return (T)MapperLoaderUtils.getMapper(entity);
    }
    public static <T extends BaseMapper<E>,E> void asyncGetMapper(final Class<E> entity,final Consumer<T> consumer){
        MapperLoaderUtils.asyncAction(new MapperLoaderUtils.Action() {
            @Override
            public void tdo() {
                consumer.accept((T)getMapper(entity));
            }
        });
    }
    public static <P,C> void selectField(FieldSelect<P,C> fieldSelectMap){
        if(fieldSelectMap == null){
            return;
        }
        FieldSelect.FieldSelectData<P,C> data = fieldSelectMap.getData();
        Class<C> childCls = data.getChildCls();
        SFunction<P,?> parentFld = data.getParentFld();
        String childCol = data.getChildColumn();
        List<String> parentKeys = data.getParentKeys();
        List<String> childKeys = data.getChildKeys();
        Assert.notNull(childCls,"from param不可为空");
        Assert.notNull(parentFld,"as param不可为空");
        Assert.notBlank(childCol,"select param不可为空");
        Assert.isTrue(parentKeys.size()>0&&childKeys.size()>0&&parentKeys.size() == childKeys.size(),"whereOrAnd param不可为空");
        String parentCol = getUnderlineName(parentFld);
        String childTab = SqlHelper.table(childCls).getTableName();
        String mapSql = "";
        String lastSql = StrUtil.isBlank(data.getChildLastSql())?"":data.getChildLastSql();
        for(int i=0;i<parentKeys.size();i++){
            if(i>0){
                mapSql += " AND ";
            }
            mapSql += childKeys.get(i)+" = "+parentKeys.get(i);
        }
        String sql = "( SELECT "+childCol+" FROM "+childTab+" WHERE "+mapSql+" "+lastSql+" ) AS "+parentCol;
        selectField(sql);
    }
    public static <P,C> void selectChildren(ChildrenSelect<P,C> childrenSelect,SFunction<P,?> parentField){
        if(childrenSelect == null){
            return;
        }
        ChildrenSelect.ChildrenSelectData<P,C> data = childrenSelect.getData();
        Class<P> parentCls = data.getParentCls();
        Class<C> childCls = data.getChildCls();
        List<String> parentKeys = data.getParentKeys();
        List<String> childKeys = data.getChildKeys();
        Assert.notNull(parentCls,"init param不可为空");
        Assert.notNull(childCls,"from param不可为空");
        Assert.isTrue(parentKeys.size()>0&&childKeys.size()>0&&parentKeys.size() == childKeys.size(),"whereOrAnd param不可为空");
        String parentFieldStr = getFieldName(parentField);
        TableInfo childInfo = SqlHelper.table(childCls);
        String childTab = childInfo.getTableName();
        List<String> childCols = data.getChildCols();
        if(childCols == null || childCols.size() == 0){
            if(childCols == null){
                childCols = new ArrayList<>();
            }
            childCols.add(childInfo.getKeyColumn());
            List<TableFieldInfo> fields = childInfo.getFieldList();
            for(TableFieldInfo field:fields){
                childCols.add(field.getColumn());
            }
        }
        String childColsStr = CollUtil.join(childCols,",");
        String mapSql = "";
        String lastSql = StrUtil.isBlank(data.getChildLastSql())?"":data.getChildLastSql();
        String parentTab = SqlHelper.table(parentCls).getTableName();
        for(int i=0;i<parentKeys.size();i++){
            if(i>0){
                mapSql += " AND ";
            }
            mapSql += childKeys.get(i)+" = "+parentKeys.get(i);
        }
        String sql = "SELECT "+childColsStr+" FROM "+childTab+" WHERE "+mapSql+" "+lastSql;
        selectChildren(sql,parentFieldStr);
    }
    public static void selectChildren(String sql,String parentField){
        if(StrUtil.isBlank(sql)){
            return;
        }
        TableChildrenSelectInterceptor.set(sql,parentField);
    }
}
