/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.mybatisplus.entity;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.tenfell.plugins.mybatisplus.utils.MapperUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class FieldSelect<P, C> {
    private FieldSelectData<P, C> data = new FieldSelectData();

    public FieldSelect() {
        this.data.setParentKeys(new ArrayList<String>());
        this.data.setChildKeys(new ArrayList<String>());
    }

    public FieldSelect<P, C> init(@NonNull Class<P> parentCls) {
        if (parentCls == null) {
            throw new NullPointerException("parentCls is marked non-null but is null");
        }
        this.data.setParentCls(parentCls);
        return this;
    }

    public FieldSelect<P, C> select(@NonNull SFunction<C, ?> childFld) {
        if (childFld == null) {
            throw new NullPointerException("childFld is marked non-null but is null");
        }
        this.select(MapperUtils.getUnderlineName(childFld));
        return this;
    }

    public FieldSelect<P, C> select(@NonNull String column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.data.setChildColumn(column);
        return this;
    }

    public FieldSelect<P, C> from(@NonNull Class<C> childCls) {
        if (childCls == null) {
            throw new NullPointerException("childCls is marked non-null but is null");
        }
        this.data.setChildCls(childCls);
        return this;
    }

    public FieldSelect<P, C> whereOrAnd(@NonNull SFunction<C, ?> childKey, @NonNull SFunction<P, ?> parentKey) {
        if (childKey == null) {
            throw new NullPointerException("childKey is marked non-null but is null");
        }
        if (parentKey == null) {
            throw new NullPointerException("parentKey is marked non-null but is null");
        }
        Class<P> parentCls = this.data.getParentCls();
        Assert.notNull(parentCls, (String)"init param\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        String parentTab = SqlHelper.table(parentCls).getTableName();
        String column = MapperUtils.getUnderlineName(childKey);
        String value = MapperUtils.getUnderlineName(parentKey);
        return this.whereOrAnd(column, parentTab + "." + value, false);
    }

    public FieldSelect<P, C> whereOrAnd(@NonNull SFunction<C, ?> childKey, @NonNull Object value) {
        if (childKey == null) {
            throw new NullPointerException("childKey is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.whereOrAnd(MapperUtils.getUnderlineName(childKey), value);
    }

    public FieldSelect<P, C> whereOrAnd(@NonNull String column, @NonNull Object value) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.whereOrAnd(column, value, true);
    }

    private FieldSelect<P, C> whereOrAnd(@NonNull String column, @NonNull Object value, boolean needYh) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.data.getChildKeys().add(column);
        String val = Convert.toStr((Object)value);
        if (value == null) {
            val = "";
        }
        if (needYh) {
            val = "'" + val + "'";
        }
        this.data.getParentKeys().add(val);
        return this;
    }

    public FieldSelect<P, C> last(String lastSql) {
        this.data.setChildLastSql(lastSql);
        return this;
    }

    public FieldSelect<P, C> as(@NonNull SFunction<P, ?> parentFld) {
        if (parentFld == null) {
            throw new NullPointerException("parentFld is marked non-null but is null");
        }
        this.data.setParentFld(parentFld);
        return this;
    }

    public FieldSelectData getData() {
        return this.data;
    }

    public static class FieldSelectData<P, C> {
        private Class<P> parentCls;
        private Class<C> childCls;
        private SFunction<P, ?> parentFld;
        private String childColumn;
        private String childLastSql;
        private List<String> parentKeys;
        private List<String> childKeys;

        public Class<P> getParentCls() {
            return this.parentCls;
        }

        public Class<C> getChildCls() {
            return this.childCls;
        }

        public SFunction<P, ?> getParentFld() {
            return this.parentFld;
        }

        public String getChildColumn() {
            return this.childColumn;
        }

        public String getChildLastSql() {
            return this.childLastSql;
        }

        public List<String> getParentKeys() {
            return this.parentKeys;
        }

        public List<String> getChildKeys() {
            return this.childKeys;
        }

        public void setParentCls(Class<P> parentCls) {
            this.parentCls = parentCls;
        }

        public void setChildCls(Class<C> childCls) {
            this.childCls = childCls;
        }

        public void setParentFld(SFunction<P, ?> parentFld) {
            this.parentFld = parentFld;
        }

        public void setChildColumn(String childColumn) {
            this.childColumn = childColumn;
        }

        public void setChildLastSql(String childLastSql) {
            this.childLastSql = childLastSql;
        }

        public void setParentKeys(List<String> parentKeys) {
            this.parentKeys = parentKeys;
        }

        public void setChildKeys(List<String> childKeys) {
            this.childKeys = childKeys;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldSelectData)) {
                return false;
            }
            FieldSelectData other = (FieldSelectData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<P> this$parentCls = this.getParentCls();
            Class<P> other$parentCls = other.getParentCls();
            if (this$parentCls == null ? other$parentCls != null : !this$parentCls.equals(other$parentCls)) {
                return false;
            }
            Class<C> this$childCls = this.getChildCls();
            Class<C> other$childCls = other.getChildCls();
            if (this$childCls == null ? other$childCls != null : !this$childCls.equals(other$childCls)) {
                return false;
            }
            SFunction<P, ?> this$parentFld = this.getParentFld();
            SFunction<P, ?> other$parentFld = other.getParentFld();
            if (this$parentFld == null ? other$parentFld != null : !this$parentFld.equals(other$parentFld)) {
                return false;
            }
            String this$childColumn = this.getChildColumn();
            String other$childColumn = other.getChildColumn();
            if (this$childColumn == null ? other$childColumn != null : !this$childColumn.equals(other$childColumn)) {
                return false;
            }
            String this$childLastSql = this.getChildLastSql();
            String other$childLastSql = other.getChildLastSql();
            if (this$childLastSql == null ? other$childLastSql != null : !this$childLastSql.equals(other$childLastSql)) {
                return false;
            }
            List<String> this$parentKeys = this.getParentKeys();
            List<String> other$parentKeys = other.getParentKeys();
            if (this$parentKeys == null ? other$parentKeys != null : !((Object)this$parentKeys).equals(other$parentKeys)) {
                return false;
            }
            List<String> this$childKeys = this.getChildKeys();
            List<String> other$childKeys = other.getChildKeys();
            return !(this$childKeys == null ? other$childKeys != null : !((Object)this$childKeys).equals(other$childKeys));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldSelectData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<P> $parentCls = this.getParentCls();
            result = result * 59 + ($parentCls == null ? 43 : $parentCls.hashCode());
            Class<C> $childCls = this.getChildCls();
            result = result * 59 + ($childCls == null ? 43 : $childCls.hashCode());
            SFunction<P, ?> $parentFld = this.getParentFld();
            result = result * 59 + ($parentFld == null ? 43 : $parentFld.hashCode());
            String $childColumn = this.getChildColumn();
            result = result * 59 + ($childColumn == null ? 43 : $childColumn.hashCode());
            String $childLastSql = this.getChildLastSql();
            result = result * 59 + ($childLastSql == null ? 43 : $childLastSql.hashCode());
            List<String> $parentKeys = this.getParentKeys();
            result = result * 59 + ($parentKeys == null ? 43 : ((Object)$parentKeys).hashCode());
            List<String> $childKeys = this.getChildKeys();
            result = result * 59 + ($childKeys == null ? 43 : ((Object)$childKeys).hashCode());
            return result;
        }

        public String toString() {
            return "FieldSelect.FieldSelectData(parentCls=" + this.getParentCls() + ", childCls=" + this.getChildCls() + ", parentFld=" + this.getParentFld() + ", childColumn=" + this.getChildColumn() + ", childLastSql=" + this.getChildLastSql() + ", parentKeys=" + this.getParentKeys() + ", childKeys=" + this.getChildKeys() + ")";
        }
    }
}

