/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.mybatisplus.interce;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class TableFieldSelectInterceptor
implements Interceptor {
    private static final ThreadLocal<List<String>> SQL_LIST = new ThreadLocal();

    public static void add(String column) {
        List<String> list = TableFieldSelectInterceptor.getSqlList();
        if (list == null) {
            list = new ArrayList<String>();
            SQL_LIST.set(list);
        }
        list.add(column);
    }

    private static List<String> getSqlList() {
        return SQL_LIST.get();
    }

    private static Object handler(Invocation invocation) throws InvocationTargetException, IllegalAccessException {
        if (TableFieldSelectInterceptor.getSqlList() != null) {
            SQL_LIST.remove();
        }
        return invocation.proceed();
    }

    public Object intercept(Invocation invocation) throws Exception {
        String originalSqlAfter;
        List<String> list = TableFieldSelectInterceptor.getSqlList();
        if (list == null || list.size() == 0) {
            return TableFieldSelectInterceptor.handler(invocation);
        }
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (!SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return TableFieldSelectInterceptor.handler(invocation);
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        String originalSql = boundSql.getSql();
        if (!StrUtil.equals((CharSequence)originalSql, (CharSequence)(originalSqlAfter = this.getTableFieldSelectSql(originalSql)))) {
            metaObject.setValue("delegate.boundSql.sql", (Object)originalSqlAfter);
        }
        return TableFieldSelectInterceptor.handler(invocation);
    }

    private String getTableFieldSelectSql(String oldSql) {
        if (!StrUtil.startWith((CharSequence)oldSql, (CharSequence)"SELECT")) {
            return oldSql;
        }
        try {
            String sql = " " + CollUtil.join(TableFieldSelectInterceptor.getSqlList(), (CharSequence)",") + ",";
            String newSql = oldSql.substring(0, 6) + sql + oldSql.substring(6);
            return newSql;
        }
        catch (Exception e) {
            return oldSql;
        }
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

