/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.mybatisplus.utils;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ibatis.javassist.ClassClassPath;
import org.apache.ibatis.javassist.ClassPath;
import org.apache.ibatis.javassist.ClassPool;
import org.apache.ibatis.javassist.CtClass;
import org.apache.ibatis.javassist.bytecode.AttributeInfo;
import org.apache.ibatis.javassist.bytecode.ClassFile;
import org.apache.ibatis.javassist.bytecode.SignatureAttribute;
import org.mybatis.spring.SqlSessionTemplate;

public class MapperLoaderUtils {
    public static SqlSessionTemplate sqlSessionTemplate;
    private static final HashMap<Class, Class> classMap;
    private static final List<Action> needInitList;

    private static Class getMapperClass(Class entity) {
        if (classMap.get(entity) != null) {
            return classMap.get(entity);
        }
        try {
            TableInfo tableInfo = SqlHelper.table((Class)entity);
            return Class.forName(tableInfo.getCurrentNamespace());
        }
        catch (Exception tableInfo) {
            String packageName = entity.getPackage().getName();
            String simpleMapperName = entity.getSimpleName() + "Mapper";
            String className = packageName + "." + simpleMapperName;
            Class mapperClass = MapperLoaderUtils.signClass(entity.getName(), className);
            classMap.put(entity, mapperClass);
            return classMap.get(entity);
        }
    }

    private static Class signClass(String beanClassName, String mapperClassName) {
        Class<BaseMapper> superClass = BaseMapper.class;
        try {
            return Class.forName(mapperClassName);
        }
        catch (Exception exception) {
            try {
                ClassPool classPool = ClassPool.getDefault();
                classPool.insertClassPath((ClassPath)new ClassClassPath(superClass));
                CtClass superMapper = classPool.getCtClass(superClass.getName());
                CtClass mapper = classPool.makeInterface(mapperClassName, superMapper);
                ClassFile classFile = mapper.getClassFile();
                String superInterfaceClazzSignature = "L" + superClass.getName().replace(".class", "").replace('.', '/');
                String signatureReturnType = "Ljava/lang/Object;";
                String paramterClassSignature = "L" + beanClassName.replace(".class", "").replace('.', '/') + ";";
                String signature = signatureReturnType + superInterfaceClazzSignature + "<" + paramterClassSignature + ">;";
                SignatureAttribute signatureAttribute = new SignatureAttribute(classFile.getConstPool(), signature);
                classFile.addAttribute((AttributeInfo)signatureAttribute);
                Class mapperClass = mapper.toClass();
                mapper.detach();
                return mapperClass;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(mapperClassName + "\u672a\u7f16\u8bd1\u6210\u529f");
                return null;
            }
        }
    }

    private static void addMapper(Class entity) {
        sqlSessionTemplate.getConfiguration().addMapper(MapperLoaderUtils.getMapperClass(entity));
    }

    public static <T extends BaseMapper<E>, E> T getMapper(Class<E> entity) {
        Object obj;
        try {
            obj = sqlSessionTemplate.getMapper(MapperLoaderUtils.getMapperClass(entity));
        }
        catch (Exception e) {
            MapperLoaderUtils.addMapper(entity);
            obj = sqlSessionTemplate.getMapper(MapperLoaderUtils.getMapperClass(entity));
        }
        return (T)((BaseMapper)obj);
    }

    public static void asyncAction(Action action) {
        if (sqlSessionTemplate == null) {
            needInitList.add(action);
        } else {
            action.tdo();
        }
    }

    public static void init(SqlSessionTemplate sqlSession) {
        sqlSessionTemplate = sqlSession;
        if (sqlSessionTemplate == null) {
            return;
        }
        if (needInitList.size() > 0) {
            Iterator<Action> it = needInitList.iterator();
            while (it.hasNext()) {
                it.next().tdo();
                it.remove();
            }
        }
    }

    static {
        classMap = new HashMap();
        needInitList = new Vector<Action>();
    }

    public static interface Action {
        public void tdo();
    }
}

