package cn.tenfell.mybatisplus.nomapper.interce;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.mybatisplus.nomapper.annotation.TableFieldChildren;
import cn.tenfell.mybatisplus.nomapper.annotation.TableFieldChildrenMap;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.*;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.SqlSession;

import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * @author fs
 */
@Intercepts({@Signature(type = ResultSetHandler.class, method = "handleResultSets", args = {Statement.class})})
public class TableFieldChildrenInterceptor implements Interceptor {
    private final static ThreadLocal<Boolean> THREAD_LOCAL = new ThreadLocal<>();
    @Override
    public Object intercept(Invocation invocation) throws Exception{
        Boolean flag = THREAD_LOCAL.get();
        if(flag == null || !flag){
            return invocation.proceed();
        }
        close();
        List list= (List)invocation.proceed();
        if(list == null || list.size() == 0){
            return list;
        }
        ResultSetHandler resultSetHandler = PluginUtils.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject(resultSetHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("mappedStatement");
        Class returnClazz = mappedStatement.getResultMaps().get(0).getType();
        Field[] fields = ReflectUtil.getFields(returnClazz);
        List<TableFieldChildren> annoList = new ArrayList<>();
        for(Field field:fields){
            TableFieldChildren fieldList =  field.getAnnotation(TableFieldChildren.class);
            if(fieldList != null){
                annoList.add(fieldList);
            }
        }
        if(annoList.size() == 0){
            return list;
        }
        List<SqlMapData> sqlMapList = new ArrayList<>();
        for(Field field:fields){
            TableFieldChildren fieldList =  field.getAnnotation(TableFieldChildren.class);
            if(fieldList == null){
                continue;
            }
            String sql = fieldList.sql();
            TableFieldChildrenMap[] keyMaps= fieldList.keys();
            Class clazz = fieldList.clazz();
            if(StrUtil.isBlank(sql) || keyMaps.length==0 || clazz == Object.class){
                continue;
            }
            TableInfo tableInfo= SqlHelper.table(clazz);
            SqlMapData sqlMap = new SqlMapData();
            sqlMap.setFieldName(field.getName());
            sqlMap.setKeyMaps(keyMaps);
            sqlMap.setSql(sql);
            sqlMap.setTableInfo(tableInfo);
            sqlMap.setSqlSession(SqlHelper.sqlSession(tableInfo.getEntityType()));
            sqlMapList.add(sqlMap);
        }
        for(SqlMapData value:sqlMapList){
            TableFieldChildrenMap[] keyMaps = value.getKeyMaps();
            String fieldName = value.getFieldName();
            for(Object obj:list){
                if(obj == null){
                    continue;
                }
                StringBuilder sb = new StringBuilder("where");
                for(TableFieldChildrenMap keyMap:keyMaps){
                    sb.append(" ").append(StrUtil.toUnderlineCase(keyMap.childField())).append("='").append(Convert.toStr(ReflectUtil.getFieldValue(obj,keyMap.parentField()))).append("' and");
                }
                sb.append(" ").append(value.getSql());
                String lastSql = sb.toString();
                List data = getChildren(lastSql,value.getTableInfo(),value.getSqlSession());
                Class fieldType = ReflectUtil.getField(obj.getClass(),fieldName).getType();
                if(fieldType.isAssignableFrom(List.class)){
                    ReflectUtil.setFieldValue(obj,fieldName,data);
                }else if(fieldType == value.getTableInfo().getEntityType() && data.size() <= 1){
                    if(data.size() == 1){
                        ReflectUtil.setFieldValue(obj,fieldName,data.get(0));
                    }else{
                        ReflectUtil.setFieldValue(obj,fieldName,null);
                    }
                }else{
                    Console.error("不支持此类型注入:{}",fieldType.toString());
                }
            }
            value.getSqlSession().close();
        }
        return list;
    }
    private List getChildren(String lastSql,TableInfo tableInfo,SqlSession sqlSession){
        MapperMethod.ParamMap paramMap = new MapperMethod.ParamMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.last(lastSql);
        paramMap.put("ew",queryWrapper);
        List list = sqlSession.selectList(tableInfo.getCurrentNamespace()+".selectList",paramMap);
        return list;
    }
    /**
     * 生成拦截对象的代理
     *
     * @param target 目标对象
     * @return 代理对象
     */
    @Override
    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            return Plugin.wrap(target, this);
        }
        return target;
    }

    /**
     * mybatis配置的属性
     *
     * @param properties mybatis配置的属性
     */
    @Override
    public void setProperties(Properties properties) {

    }
    public static void open(){
        THREAD_LOCAL.set(true);
    }
    public static void close(){
        THREAD_LOCAL.set(false);
    }
    public class SqlMapData{
        private String fieldName;
        private String sql;
        private TableInfo tableInfo;
        private SqlSession sqlSession;
        private TableFieldChildrenMap[] keyMaps;

        public String getFieldName() {
            return fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getSql() {
            return sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public TableInfo getTableInfo() {
            return tableInfo;
        }

        public void setTableInfo(TableInfo tableInfo) {
            this.tableInfo = tableInfo;
        }

        public SqlSession getSqlSession() {
            return sqlSession;
        }

        public void setSqlSession(SqlSession sqlSession) {
            this.sqlSession = sqlSession;
        }

        public TableFieldChildrenMap[] getKeyMaps() {
            return keyMaps;
        }

        public void setKeyMaps(TableFieldChildrenMap[] keyMaps) {
            this.keyMaps = keyMaps;
        }
    }

}
