package cn.tenfell.mybatisplus.nomapper.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.crypto.SecureUtil;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.mybatis.spring.SqlSessionTemplate;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.*;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MapperLoader {
    private static String classPath;
    public static SqlSessionTemplate sqlSessionTemplate;
    private static final HashMap<Class,Class> classMap = new HashMap<>();
    private static final List<Supplier> needInitList = new ArrayList<>();
    private static Class getMapperClass(Class entity){
        if(classMap.get(entity) != null){
            return classMap.get(entity);
        }
        try{
            TableInfo tableInfo = SqlHelper.table(entity);
            return Class.forName(tableInfo.getCurrentNamespace());
        }catch (Exception e){

        }
        String packageName = entity.getPackage().getName();
        String simpleMapperName = entity.getSimpleName()+"Mapper";
        String javaCode = "package "+packageName+";public interface "+simpleMapperName+" extends "+ BaseMapper.class.getName() +"<"+entity.getName()+">{}";
        String className = packageName+"."+simpleMapperName;
        if(classPath == null){
            initClassPath();
        }
        Class<?> mapperClass = ClassLoaderUtils.compile(className,javaCode,classPath);
        classMap.put(entity,mapperClass);
        return classMap.get(entity);
    }
    private static void initClassPath(){
        classPath = "";
        try{
            URL localUrl = MapperLoader.class.getResource("/");
            String folder=System.getProperty("java.io.tmpdir");
            String path = folder+ SecureUtil.md5(localUrl.toString())+File.separator;
            String localPath = "";
            if("jar".equals(localUrl.getProtocol())){
                JarURLConnection conn = (JarURLConnection)localUrl.openConnection();
                JarFile jarFile = conn.getJarFile();
                Enumeration<JarEntry> entries =  jarFile.entries();
                while (entries.hasMoreElements()){
                    JarEntry jarEntry = entries.nextElement();
                    if(jarEntry.getName().endsWith(".class")){
                        FileUtil.writeFromStream(URLUtil.url(localUrl.toString()+jarEntry.getName()).openStream(),path+jarEntry.getName());
                    }
                }
                localPath = path;
            }else{
                localPath = new File(localUrl.getPath()).getPath();
            }
            URL baseUrl = BaseMapper.class.getResource("");
            String basePath = "";
            if("jar".equals(baseUrl.getProtocol())){
                JarURLConnection conn = (JarURLConnection)baseUrl.openConnection();
                String filePath = path+"mybatis-plus-core.jar";
                FileUtil.writeFromStream(conn.getJarFileURL().openStream(),filePath);
                basePath = filePath;
            }else{
                basePath = new File(localUrl.getPath()).getPath();
            }
            classPath = basePath+ File.pathSeparator+localPath;
        }catch (Exception e){
            e.printStackTrace();
        }

    }
    private static void addMapper(Class entity){
        sqlSessionTemplate.getConfiguration().addMapper(getMapperClass(entity));
    }
    public static <T> T getMapper(Class entity){
        Object obj;
        try{
            obj = sqlSessionTemplate.getMapper(getMapperClass(entity));
        }catch (Exception e){
            addMapper(entity);
            obj = sqlSessionTemplate.getMapper(getMapperClass(entity));
        }
        return (T)obj;
    }
    public static void asyncAction(Supplier supplier){
        if(MapperLoader.sqlSessionTemplate == null){
            MapperLoader.needInitList.add(supplier);
        }else{
            supplier.get();
        }
    }
    public static void init(SqlSessionTemplate sqlSession){
        MapperLoader.sqlSessionTemplate = sqlSession;
        if(MapperLoader.needInitList.size()>0){
            Iterator<Supplier> it=MapperLoader.needInitList.iterator();
            while(it.hasNext()){
                it.next().get();
                it.remove();
            }
        }
    }

}
