/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.clink.cdc.mysql.debezium;

import cn.tenmg.dsl.utils.MapUtils;
import cn.tenmg.dsl.utils.StringUtils;
import io.debezium.data.Envelope;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.cdc.debezium.table.DeserializationRuntimeConverter;
import org.apache.flink.cdc.debezium.table.MetadataConverter;
import org.apache.flink.cdc.debezium.utils.TemporalConversions;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public class MultiTableDebeziumDeserializationSchema
implements DebeziumDeserializationSchema<Tuple2<String, Row>> {
    private static final long serialVersionUID = -1296320474773132864L;
    private final Map<String, RowType> rowTypes;
    private final Map<String, Map<Integer, MetadataConverter>> metadataConverters;
    private final boolean convertDeleteToUpdate;
    private final Map<String, DeserializationRuntimeConverter> physicalConverters = MapUtils.newHashMap();

    public MultiTableDebeziumDeserializationSchema(Map<String, RowType> rowTypes, Map<String, Map<Integer, MetadataConverter>> metadataConverters, boolean convertDeleteToUpdate) {
        this.rowTypes = rowTypes;
        this.metadataConverters = metadataConverters == null ? MapUtils.newHashMap() : metadataConverters;
        this.convertDeleteToUpdate = convertDeleteToUpdate;
        for (String tablename : this.rowTypes.keySet()) {
            RowType rowType = this.rowTypes.get(tablename);
            DeserializationRuntimeConverter physicalConverter = MultiTableDebeziumDeserializationSchema.createNotNullConverter((LogicalType)rowType);
            this.physicalConverters.put(tablename, physicalConverter);
        }
    }

    public void deserialize(SourceRecord record, Collector<Tuple2<String, Row>> out) throws Exception {
        Row before;
        Envelope.Operation op = Envelope.operationFor((SourceRecord)record);
        Struct value = (Struct)record.value();
        Schema valueSchema = record.valueSchema();
        Struct source = value.getStruct("source");
        String databaseName = source.getString("db");
        String tablename = source.get("table").toString();
        DeserializationRuntimeConverter physicalConverter = null;
        if (databaseName != null) {
            String fullName = StringUtils.concat((String[])new String[]{databaseName, ".", tablename});
            physicalConverter = this.physicalConverters.get(fullName);
            if (physicalConverter == null) {
                physicalConverter = this.physicalConverters.get(tablename);
            } else {
                tablename = fullName;
            }
        } else {
            physicalConverter = this.physicalConverters.get(tablename);
        }
        if (op == Envelope.Operation.CREATE || op == Envelope.Operation.READ) {
            Row insert = this.extractAfterRow(value, valueSchema, physicalConverter);
            insert.setKind(RowKind.INSERT);
            this.setMetadatas(tablename, insert, record);
            out.collect((Object)Tuple2.of((Object)tablename, (Object)insert));
        } else if (op == Envelope.Operation.DELETE) {
            if (this.convertDeleteToUpdate) {
                before = this.extractBeforeRow(value, valueSchema, physicalConverter);
                before.setKind(RowKind.UPDATE_BEFORE);
                this.setMetadatas(tablename, before, record);
                out.collect((Object)Tuple2.of((Object)tablename, (Object)before));
                int arity = before.getArity();
                Row after = new Row(RowKind.UPDATE_AFTER, arity);
                for (int i = 0; i < arity; ++i) {
                    after.setField(i, before.getField(i));
                }
                out.collect((Object)Tuple2.of((Object)tablename, (Object)after));
            } else {
                Row delete = this.extractBeforeRow(value, valueSchema, physicalConverter);
                delete.setKind(RowKind.DELETE);
                this.setMetadatas(tablename, delete, record);
                out.collect((Object)Tuple2.of((Object)tablename, (Object)delete));
            }
        } else {
            before = this.extractBeforeRow(value, valueSchema, physicalConverter);
            before.setKind(RowKind.UPDATE_BEFORE);
            this.setMetadatas(tablename, before, record);
            out.collect((Object)Tuple2.of((Object)tablename, (Object)before));
            Row after = this.extractAfterRow(value, valueSchema, physicalConverter);
            after.setKind(RowKind.UPDATE_AFTER);
            this.setMetadatas(tablename, after, record);
            out.collect((Object)Tuple2.of((Object)tablename, (Object)after));
        }
    }

    private Row extractAfterRow(Struct value, Schema valueSchema, DeserializationRuntimeConverter physicalConverter) throws Exception {
        Schema afterSchema = valueSchema.field("after").schema();
        Struct after = value.getStruct("after");
        return (Row)physicalConverter.convert((Object)after, afterSchema);
    }

    private Row extractBeforeRow(Struct value, Schema valueSchema, DeserializationRuntimeConverter physicalConverter) throws Exception {
        Schema beforeSchema = valueSchema.field("before").schema();
        Struct before = value.getStruct("before");
        return (Row)physicalConverter.convert((Object)before, beforeSchema);
    }

    private void setMetadatas(String tableName, Row row, SourceRecord record) {
        for (Map.Entry<Integer, MetadataConverter> entry : this.metadataConverters.get(tableName).entrySet()) {
            row.setField(entry.getKey().intValue(), entry.getValue().read(record));
        }
    }

    public TypeInformation<Tuple2<String, Row>> getProducedType() {
        return TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, Row>>(){});
    }

    public static DeserializationRuntimeConverter createNotNullConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return new DeserializationRuntimeConverter(){
                    private static final long serialVersionUID = -5531578281942128706L;

                    public Object convert(Object dbzObj, Schema schema) {
                        return null;
                    }
                };
            }
            case BOOLEAN: {
                return MultiTableDebeziumDeserializationSchema.convertToBoolean();
            }
            case TINYINT: {
                return new DeserializationRuntimeConverter(){
                    private static final long serialVersionUID = 5826210245541496242L;

                    public Object convert(Object dbzObj, Schema schema) {
                        return Byte.parseByte(dbzObj.toString());
                    }
                };
            }
            case SMALLINT: {
                return new DeserializationRuntimeConverter(){
                    private static final long serialVersionUID = 202642317319921270L;

                    public Object convert(Object dbzObj, Schema schema) {
                        return Short.parseShort(dbzObj.toString());
                    }
                };
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return MultiTableDebeziumDeserializationSchema.convertToInt();
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return MultiTableDebeziumDeserializationSchema.convertToLong();
            }
            case DATE: {
                return MultiTableDebeziumDeserializationSchema.convertToDate();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return MultiTableDebeziumDeserializationSchema.convertToTime();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return MultiTableDebeziumDeserializationSchema.convertToTimestamp(ZoneId.of("UTC"));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return MultiTableDebeziumDeserializationSchema.convertToLocalTimeZoneTimestamp(ZoneId.of("UTC"));
            }
            case FLOAT: {
                return MultiTableDebeziumDeserializationSchema.convertToFloat();
            }
            case DOUBLE: {
                return MultiTableDebeziumDeserializationSchema.convertToDouble();
            }
            case CHAR: 
            case VARCHAR: {
                return MultiTableDebeziumDeserializationSchema.convertToString();
            }
            case BINARY: 
            case VARBINARY: {
                return MultiTableDebeziumDeserializationSchema.convertToBinary();
            }
            case DECIMAL: {
                return MultiTableDebeziumDeserializationSchema.createDecimalConverter((DecimalType)type);
            }
            case ROW: {
                return MultiTableDebeziumDeserializationSchema.createRowConverter((RowType)type);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static DeserializationRuntimeConverter convertToBoolean() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = -4161081671092573975L;

            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Boolean) {
                    return dbzObj;
                }
                if (dbzObj instanceof Byte) {
                    return (Byte)dbzObj == 1;
                }
                if (dbzObj instanceof Short) {
                    return (Short)dbzObj == 1;
                }
                return Boolean.parseBoolean(dbzObj.toString());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToInt() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = -7463894054578628927L;

            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Integer) {
                    return dbzObj;
                }
                if (dbzObj instanceof Long) {
                    return ((Long)dbzObj).intValue();
                }
                return Integer.parseInt(dbzObj.toString());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToLong() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 2855410652461690993L;

            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Integer) {
                    return ((Integer)dbzObj).longValue();
                }
                if (dbzObj instanceof Long) {
                    return dbzObj;
                }
                return Long.parseLong(dbzObj.toString());
            }
        };
    }

    private static DeserializationRuntimeConverter createDecimalConverter(DecimalType decimalType) {
        final int precision = decimalType.getPrecision();
        final int scale = decimalType.getScale();
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = -7856160950422977488L;

            public Object convert(Object dbzObj, Schema schema) {
                BigDecimal bigDecimal;
                if (dbzObj instanceof byte[]) {
                    bigDecimal = Decimal.toLogical((Schema)schema, (byte[])((byte[])dbzObj));
                } else if (dbzObj instanceof String) {
                    bigDecimal = new BigDecimal((String)dbzObj);
                } else if (dbzObj instanceof Double) {
                    bigDecimal = BigDecimal.valueOf((Double)dbzObj);
                } else if ("io.debezium.data.VariableScaleDecimal".equals(schema.name())) {
                    SpecialValueDecimal decimal = VariableScaleDecimal.toLogical((Struct)((Struct)dbzObj));
                    bigDecimal = decimal.getDecimalValue().orElse(BigDecimal.ZERO);
                } else {
                    bigDecimal = new BigDecimal(dbzObj.toString());
                }
                return DecimalData.fromBigDecimal((BigDecimal)bigDecimal, (int)precision, (int)scale);
            }
        };
    }

    private static DeserializationRuntimeConverter convertToDouble() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 2217554325155415123L;

            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Float) {
                    return ((Float)dbzObj).doubleValue();
                }
                if (dbzObj instanceof Double) {
                    return dbzObj;
                }
                return Double.parseDouble(dbzObj.toString());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToFloat() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 6586191898979457725L;

            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Float) {
                    return dbzObj;
                }
                if (dbzObj instanceof Double) {
                    return Float.valueOf(((Double)dbzObj).floatValue());
                }
                return Float.valueOf(Float.parseFloat(dbzObj.toString()));
            }
        };
    }

    private static DeserializationRuntimeConverter convertToDate() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = -4898068849755140790L;

            public Object convert(Object dbzObj, Schema schema) {
                return (int)TemporalConversions.toLocalDate((Object)dbzObj).toEpochDay();
            }
        };
    }

    private static DeserializationRuntimeConverter convertToTime() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 6637768283717546945L;

            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Long) {
                    switch (schema.name()) {
                        case "io.debezium.time.MicroTime": {
                            return (int)((Long)dbzObj / 1000L);
                        }
                        case "io.debezium.time.NanoTime": {
                            return (int)((Long)dbzObj / 1000000L);
                        }
                    }
                } else if (dbzObj instanceof Integer) {
                    return dbzObj;
                }
                return TemporalConversions.toLocalTime((Object)dbzObj).toSecondOfDay() * 1000;
            }
        };
    }

    private static DeserializationRuntimeConverter convertToTimestamp(final ZoneId serverTimeZone) {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = -3377296602526652049L;

            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Long) {
                    switch (schema.name()) {
                        case "io.debezium.time.Timestamp": {
                            return TimestampData.fromEpochMillis((long)((Long)dbzObj));
                        }
                        case "io.debezium.time.MicroTimestamp": {
                            long micro = (Long)dbzObj;
                            return TimestampData.fromEpochMillis((long)(micro / 1000L), (int)((int)(micro % 1000L * 1000L)));
                        }
                        case "io.debezium.time.NanoTimestamp": {
                            long nano = (Long)dbzObj;
                            return TimestampData.fromEpochMillis((long)(nano / 1000000L), (int)((int)(nano % 1000000L)));
                        }
                    }
                }
                LocalDateTime localDateTime = TemporalConversions.toLocalDateTime((Object)dbzObj, (ZoneId)serverTimeZone);
                return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime);
            }
        };
    }

    private static DeserializationRuntimeConverter convertToLocalTimeZoneTimestamp(final ZoneId serverTimeZone) {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = -504319898823637587L;

            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof String) {
                    String str = (String)dbzObj;
                    Instant instant = Instant.parse(str);
                    return TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.ofInstant(instant, serverTimeZone));
                }
                throw new IllegalArgumentException("Unable to convert to TimestampData from unexpected value '" + dbzObj + "' of type " + dbzObj.getClass().getName());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToString() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = -5832036125040167926L;

            public Object convert(Object dbzObj, Schema schema) {
                return StringData.fromString((String)dbzObj.toString());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToBinary() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 2035408470878061374L;

            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof byte[]) {
                    return dbzObj;
                }
                if (dbzObj instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)dbzObj;
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(bytes);
                    return bytes;
                }
                throw new UnsupportedOperationException("Unsupported BYTES value type: " + dbzObj.getClass().getSimpleName());
            }
        };
    }

    private static DeserializationRuntimeConverter createRowConverter(RowType rowType) {
        List fields = rowType.getFields();
        int size = fields.size();
        final DeserializationRuntimeConverter[] fieldConverters = new DeserializationRuntimeConverter[size];
        for (int i = 0; i < size; ++i) {
            fieldConverters[i] = MultiTableDebeziumDeserializationSchema.createNotNullConverter(((RowType.RowField)fields.get(i)).getType());
        }
        final String[] fieldNames = rowType.getFieldNames().toArray(new String[size]);
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 5939600101571940500L;

            public Object convert(Object dbzObj, Schema schema) throws Exception {
                Struct struct = (Struct)dbzObj;
                int arity = fieldNames.length;
                Row row = new Row(arity);
                for (int i = 0; i < arity; ++i) {
                    String fieldName = fieldNames[i];
                    Field field = schema.field(fieldName);
                    if (field == null) {
                        row.setField(i, null);
                        continue;
                    }
                    Object fieldValue = struct.getWithoutDefault(fieldName);
                    Schema fieldSchema = field.schema();
                    Object convertedField = MultiTableDebeziumDeserializationSchema.convertField(fieldConverters[i], fieldValue, fieldSchema);
                    row.setField(i, convertedField);
                }
                return row;
            }
        };
    }

    private static Object convertField(DeserializationRuntimeConverter fieldConverter, Object fieldValue, Schema fieldSchema) throws Exception {
        if (fieldValue == null) {
            return null;
        }
        return fieldConverter.convert(fieldValue, fieldSchema);
    }
}

