/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.clink.cdc.oracle.source;

import cn.tenmg.clink.cdc.oracle.debezium.MultiTableDebeziumDeserializationSchema;
import cn.tenmg.clink.source.SourceFactory;
import cn.tenmg.dsl.utils.MapUtils;
import cn.tenmg.dsl.utils.SetUtils;
import cn.tenmg.dsl.utils.StringUtils;
import com.ververica.cdc.connectors.base.options.JdbcSourceOptions;
import com.ververica.cdc.connectors.base.options.SourceOptions;
import com.ververica.cdc.connectors.base.options.StartupMode;
import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.base.source.jdbc.JdbcIncrementalSource;
import com.ververica.cdc.connectors.oracle.source.OracleSourceBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.table.DebeziumOptions;
import com.ververica.cdc.debezium.table.MetadataConverter;
import io.debezium.data.Envelope;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

public class OracleCdcSourceFactory
implements SourceFactory<JdbcIncrementalSource<Tuple2<String, Row>>> {
    public static final String IDENTIFIER = "oracle-cdc";
    private static final String TABLE_NAME = "table-name";
    private static final String INCLUDE_SCHEMA_CHANGES = "include-schema-changes";
    private static final String CONVERT_DELETE_TO_UPDATE = "convert-delete-to-update";
    private static final String SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN = JdbcSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN.key();
    private static final String SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED = "scan.incremental.close-idle-reader.enabled";
    private static final String CLOSE_IDLE_READERS_METHOD_NAME = "closeIdleReaders";
    private static final String SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP = "scan.incremental.snapshot.backfill.skip";
    private static final String SKIP_SNAPSHOT_BACKFILL_METHOD_NAME = "skipSnapshotBackfill";
    private static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the Oracle database server.");
    private static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)1433).withDescription("Integer port number of the Oracle database server.");
    private static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the Oracle database to use when connecting to the Oracle database server.");
    private static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the Oracle database server.");
    private static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the Oracle server to monitor.");
    private static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for Oracle CDC consumer, valid enumerations are \"initial\", \"initial-only\", \"latest-offset\"");
    private static final String SCAN_STARTUP_MODE_VALUE_INITIAL = "initial";
    private static final String SCAN_STARTUP_MODE_VALUE_EARLIEST = "earliest-offset";
    private static final String SCAN_STARTUP_MODE_VALUE_LATEST = "latest-offset";
    private static final String SCAN_STARTUP_MODE_VALUE_SPECIFIC_OFFSET = "specific-offset";
    private static final String SCAN_STARTUP_MODE_VALUE_TIMESTAMP = "timestamp";
    private static final Map<String, MetadataConverter> METADATA_CONVERTERS = MapUtils.newHashMapBuilder(String.class, MetadataConverter.class).put((Object)"table_name", (Object)new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("table"));
        }
    }).put((Object)"database_name", (Object)new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("db"));
        }
    }).put((Object)"op_ts", (Object)new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return TimestampData.fromEpochMillis((long)((Long)sourceStruct.get("ts_ms")));
        }
    }).put((Object)"op", (Object)new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Envelope.Operation op = Envelope.operationFor((SourceRecord)record);
            if (op == Envelope.Operation.CREATE || op == Envelope.Operation.READ) {
                return StringData.fromString((String)"c");
            }
            if (op == Envelope.Operation.DELETE) {
                return StringData.fromString((String)"d");
            }
            return StringData.fromString((String)"u");
        }
    }).build();

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public JdbcIncrementalSource<Tuple2<String, Row>> create(Map<String, String> config, Map<String, RowType> rowTypes, Map<String, Map<Integer, String>> metadatas) {
        String schemaNames = OracleCdcSourceFactory.getOrDefault(config, (ConfigOption<String>)JdbcSourceOptions.SCHEMA_NAME);
        HashSet schemas = schemaNames == null ? Collections.emptySet() : SetUtils.newHashSet((Object[])OracleCdcSourceFactory.trimAll(schemaNames.split(",")));
        HashSet<String> tables = new HashSet<String>();
        String[] tableNames = OracleCdcSourceFactory.toArray(config.get(TABLE_NAME));
        if (tableNames == null) {
            for (String tableName : rowTypes.keySet()) {
                String[] parts = tableName.split("\\.", 2);
                if (parts.length > 1 || schemas.isEmpty()) {
                    tables.add(tableName);
                    continue;
                }
                Iterator it = schemas.iterator();
                while (it.hasNext()) {
                    tables.add(StringUtils.concat((String[])new String[]{(String)it.next(), ".", tableName}));
                }
            }
        } else {
            for (String tableName : tableNames) {
                String[] parts = tableName.split("\\.", 2);
                if (parts.length > 1 || schemas.isEmpty()) {
                    tables.add(tableName);
                    continue;
                }
                Iterator it = schemas.iterator();
                while (it.hasNext()) {
                    tables.add(StringUtils.concat((String[])new String[]{(String)it.next(), ".", tableName}));
                }
            }
        }
        OracleSourceBuilder builder = OracleSourceBuilder.OracleIncrementalSource.builder().hostname(OracleCdcSourceFactory.getOrDefault(config, HOSTNAME)).port(OracleCdcSourceFactory.getIntegerOrDefault(config, PORT).intValue()).username(OracleCdcSourceFactory.getOrDefault(config, USERNAME)).password(OracleCdcSourceFactory.getOrDefault(config, PASSWORD)).databaseList(OracleCdcSourceFactory.toArray(OracleCdcSourceFactory.getOrDefault(config, DATABASE_NAME))).schemaList(OracleCdcSourceFactory.toArray(schemas)).tableList(OracleCdcSourceFactory.toArray(tables)).debeziumProperties(DebeziumOptions.getDebeziumProperties(config));
        StartupOptions startupOptions = OracleCdcSourceFactory.getStartupOptions(config);
        this.validateStartupOption(startupOptions);
        builder.startupOptions(startupOptions);
        int splitSize = OracleCdcSourceFactory.getIntegerOrDefault(config, (ConfigOption<Integer>)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE);
        this.validateIntegerOption((ConfigOption<Integer>)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE, splitSize, 1);
        builder.splitSize(splitSize);
        int fetchSize = OracleCdcSourceFactory.getIntegerOrDefault(config, (ConfigOption<Integer>)SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE);
        this.validateIntegerOption((ConfigOption<Integer>)SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE, fetchSize, 1);
        builder.fetchSize(fetchSize);
        int splitMetaGroupSize = OracleCdcSourceFactory.getIntegerOrDefault(config, (ConfigOption<Integer>)SourceOptions.CHUNK_META_GROUP_SIZE);
        this.validateIntegerOption((ConfigOption<Integer>)SourceOptions.CHUNK_META_GROUP_SIZE, splitMetaGroupSize, 1);
        builder.splitMetaGroupSize(splitMetaGroupSize);
        int connectionPoolSize = OracleCdcSourceFactory.getIntegerOrDefault(config, (ConfigOption<Integer>)JdbcSourceOptions.CONNECTION_POOL_SIZE);
        this.validateIntegerOption((ConfigOption<Integer>)JdbcSourceOptions.CONNECTION_POOL_SIZE, connectionPoolSize, 1);
        builder.connectionPoolSize(connectionPoolSize);
        int connectMaxRetries = OracleCdcSourceFactory.getIntegerOrDefault(config, (ConfigOption<Integer>)JdbcSourceOptions.CONNECT_MAX_RETRIES);
        this.validateIntegerOption((ConfigOption<Integer>)JdbcSourceOptions.CONNECT_MAX_RETRIES, connectMaxRetries, 0);
        builder.connectMaxRetries(connectMaxRetries);
        builder.distributionFactorLower(Double.parseDouble(OracleCdcSourceFactory.getOrDefault(config, Arrays.asList("chunk-key.even-distribution.factor.lower-bound", "split-key.even-distribution.factor.lower-bound"), "0.05")));
        builder.distributionFactorUpper(Double.parseDouble(OracleCdcSourceFactory.getOrDefault(config, Arrays.asList("chunk-key.even-distribution.factor.upper-bound", "split-key.even-distribution.factor.upper-bound"), "1000")));
        builder.connectTimeout(OracleCdcSourceFactory.getDurationOrDefault(config, (ConfigOption<Duration>)JdbcSourceOptions.CONNECT_TIMEOUT));
        if (config.containsKey(INCLUDE_SCHEMA_CHANGES)) {
            builder.includeSchemaChanges(Boolean.valueOf(config.get(INCLUDE_SCHEMA_CHANGES)).booleanValue());
        }
        if (config.containsKey(SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN)) {
            builder.chunkKeyColumn(config.get(SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN));
        }
        if (config.containsKey(SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED)) {
            this.setbooleanOptionIfPossible(builder, CLOSE_IDLE_READERS_METHOD_NAME, Boolean.valueOf(config.get(SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED)));
        }
        if (config.containsKey(SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP)) {
            this.setbooleanOptionIfPossible(builder, SKIP_SNAPSHOT_BACKFILL_METHOD_NAME, Boolean.valueOf(config.get(SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP)));
        }
        String convertDeleteToUpdate = config.get(CONVERT_DELETE_TO_UPDATE);
        return builder.deserializer((DebeziumDeserializationSchema)new MultiTableDebeziumDeserializationSchema(rowTypes, this.toMetadataConverters(metadatas), convertDeleteToUpdate == null ? false : Boolean.parseBoolean(convertDeleteToUpdate))).build();
    }

    private static String[] toArray(Set<String> strs) {
        return strs.toArray(new String[strs.size()]);
    }

    private static String[] toArray(String str) {
        if (str == null) {
            return null;
        }
        return OracleCdcSourceFactory.trimAll(str.split(","));
    }

    private static String[] trimAll(String[] strs) {
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = strs[i].trim();
        }
        return strs;
    }

    private static String getOrDefault(Map<String, String> config, ConfigOption<String> option) {
        if (config.containsKey(option.key())) {
            return config.get(option.key());
        }
        return (String)option.defaultValue();
    }

    private static Integer getIntegerOrDefault(Map<String, String> config, ConfigOption<Integer> option) {
        if (config.containsKey(option.key())) {
            return Integer.parseInt(config.get(option.key()));
        }
        return (Integer)option.defaultValue();
    }

    private static String getOrDefault(Map<String, String> config, List<String> priorityKeys, String defaultValue) {
        int size = priorityKeys.size();
        for (int i = 0; i < size; ++i) {
            String key = priorityKeys.get(i);
            if (!config.containsKey(key)) continue;
            return config.get(key);
        }
        return defaultValue;
    }

    private static Duration getDurationOrDefault(Map<String, String> config, ConfigOption<Duration> option) {
        if (config.containsKey(option.key())) {
            return TimeUtils.parseDuration((String)config.get(option.key()));
        }
        return (Duration)option.defaultValue();
    }

    private void setbooleanOptionIfPossible(Object obj, String name, boolean value) {
        try {
            obj.getClass().getDeclaredMethod(name, Boolean.TYPE).invoke(obj, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static StartupOptions getStartupOptions(Map<String, String> config) {
        String modeString = OracleCdcSourceFactory.getOrDefault(config, SCAN_STARTUP_MODE);
        switch (modeString.toLowerCase()) {
            case "initial": {
                return StartupOptions.initial();
            }
            case "latest-offset": {
                return StartupOptions.latest();
            }
            case "earliest-offset": 
            case "specific-offset": 
            case "timestamp": {
                throw new ValidationException(String.format("Unsupported option value '%s', the options [%s, %s, %s] are not supported correctly, please do not use them until they're correctly supported", modeString, SCAN_STARTUP_MODE_VALUE_EARLIEST, SCAN_STARTUP_MODE_VALUE_SPECIFIC_OFFSET, SCAN_STARTUP_MODE_VALUE_TIMESTAMP));
            }
        }
        throw new ValidationException(String.format("Invalid value for option '%s'. Supported values are [%s, %s], but was: %s", SCAN_STARTUP_MODE.key(), SCAN_STARTUP_MODE_VALUE_INITIAL, SCAN_STARTUP_MODE_VALUE_LATEST, modeString));
    }

    private void validateStartupOption(StartupOptions startupOptions) {
        Preconditions.checkState((startupOptions.startupMode == StartupMode.INITIAL || startupOptions.startupMode == StartupMode.LATEST_OFFSET ? 1 : 0) != 0, (Object)String.format("PostgreSQL Parallel Source only supports startup mode 'initial' and 'latest-offset', but actual is %s", startupOptions.startupMode));
    }

    private void validateIntegerOption(ConfigOption<Integer> option, int optionValue, int exclusiveMin) {
        Preconditions.checkState((optionValue > exclusiveMin ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must larger than %d, but is %d", option.key(), exclusiveMin, optionValue));
    }

    private Map<String, Map<Integer, MetadataConverter>> toMetadataConverters(Map<String, Map<Integer, String>> metadatas) {
        if (MapUtils.isEmpty(metadatas)) {
            return Collections.emptyMap();
        }
        HashMap metadataConverterses = MapUtils.newHashMap();
        for (Map.Entry<String, Map<Integer, String>> entry : metadatas.entrySet()) {
            HashMap metadataConverters = MapUtils.newHashMap();
            for (Map.Entry<Integer, String> e : entry.getValue().entrySet()) {
                MetadataConverter metadataConverter = METADATA_CONVERTERS.get(e.getValue());
                if (metadataConverter == null) {
                    throw new UnsupportedOperationException("Invalid metadata: " + e.getValue() + " for the connector: " + IDENTIFIER);
                }
                metadataConverters.put(e.getKey(), metadataConverter);
            }
            metadataConverterses.put(entry.getKey(), metadataConverters);
        }
        return metadataConverterses;
    }
}

