/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.clink.utils;

import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.MapUtils;
import cn.tenmg.dsl.utils.SetUtils;
import cn.tenmg.dsl.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ConfigurationUtils {
    public static final String EMPTY_STRING = "";
    private static final char VALUE_BEGIN = '=';
    private static final Set<Character> VALUE_END = SetUtils.newHashSet(Character.valueOf(','), Character.valueOf('\r'), Character.valueOf('\n'));

    public static Map<String, String> load(String config) {
        if (config == null) {
            return null;
        }
        HashMap<String, String> map = MapUtils.newHashMap();
        config = config.trim();
        int len = config.length();
        int i = 0;
        int backslashes = 0;
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        boolean isKey = true;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        while (i < len) {
            char c = config.charAt(i);
            if (isString) {
                if (c == '\\') {
                    ++backslashes;
                } else {
                    if (DSLUtils.isStringEnd(a, b, c, backslashes)) {
                        isString = false;
                    }
                    backslashes = 0;
                }
                if (isKey) {
                    key.append(c);
                } else {
                    value.append(c);
                }
            } else if (c == '\'') {
                isString = true;
                if (isKey) {
                    key.append(c);
                } else {
                    value.append(c);
                }
            } else if (isKey) {
                if (c == '=') {
                    isKey = false;
                } else {
                    key.append(c);
                }
            } else {
                if (VALUE_END.contains(Character.valueOf(c))) {
                    isKey = true;
                    ConfigurationUtils.put(map, key, value);
                    key.setLength(0);
                    value.setLength(0);
                    a = b;
                    b = c;
                    ++i;
                    while (i < len && (c = config.charAt(i)) <= ' ') {
                        a = b;
                        b = c;
                        ++i;
                    }
                    continue;
                }
                value.append(c);
            }
            a = b;
            b = c;
            ++i;
        }
        if (key.length() > 0) {
            ConfigurationUtils.put(map, key, value);
        }
        return map;
    }

    public static Properties getPrefixedKeyValuePairs(Map<String, String> config, String prefix, boolean camelCaseKey) {
        Properties keyValuePairs = new Properties();
        if (camelCaseKey) {
            for (Map.Entry<String, String> entry : config.entrySet()) {
                String key = entry.getKey().toString();
                if (!key.startsWith(prefix)) continue;
                keyValuePairs.put(StringUtils.toCamelCase(key.substring(prefix.length()), "[_-]", false), entry.getValue());
            }
        } else {
            for (Map.Entry<String, String> entry : config.entrySet()) {
                String key = entry.getKey().toString();
                if (!key.startsWith(prefix)) continue;
                keyValuePairs.put(key.substring(prefix.length()), entry.getValue());
            }
        }
        return keyValuePairs;
    }

    public static Properties getPrefixedKeyValuePairs(Properties config, String prefix, boolean camelCaseKey) {
        Properties keyValuePairs = new Properties();
        if (camelCaseKey) {
            for (Map.Entry<Object, Object> entry : config.entrySet()) {
                String key = entry.getKey().toString();
                if (!key.startsWith(prefix)) continue;
                keyValuePairs.put(StringUtils.toCamelCase(key.substring(prefix.length()), "[_-]", false), entry.getValue());
            }
        } else {
            for (Map.Entry<Object, Object> entry : config.entrySet()) {
                String key = entry.getKey().toString();
                if (!key.startsWith(prefix)) continue;
                keyValuePairs.put(key.substring(prefix.length()), entry.getValue());
            }
        }
        return keyValuePairs;
    }

    public static String getProperty(Properties config, List<String> priorKeys) {
        return ConfigurationUtils.getProperty(config, priorKeys, null);
    }

    public static String getProperty(Properties config, List<String> priorKeys, String defaultValue) {
        int size = priorKeys.size();
        for (int i = 0; i < size; ++i) {
            String key = priorKeys.get(i);
            if (!config.containsKey(key)) continue;
            return config.getProperty(key);
        }
        return defaultValue;
    }

    public static boolean isJDBC(Map<String, String> dataSource) {
        return "jdbc".equals(dataSource.get("connector"));
    }

    public static boolean isKafka(Map<String, String> dataSource) {
        return "kafka".equals(dataSource.get("connector"));
    }

    private static void put(Map<String, String> map, StringBuilder key, StringBuilder value) {
        String k = key.toString().trim();
        String v = value.toString().trim();
        int last = k.length() - 1;
        if (k.charAt(0) == '\'' && k.charAt(last) == '\'') {
            k = k.substring(1, last);
        }
        if (StringUtils.isNotBlank(v)) {
            last = v.length() - 1;
            if (v.charAt(0) == '\'' && v.charAt(last) == '\'') {
                v = v.substring(1, last);
            }
        }
        map.put(k, v);
    }
}

