/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.parser;

import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JDBCParamsParser
implements ParamsParser<List<Object>> {
    private static final JDBCParamsParser INSTANCE = new JDBCParamsParser();

    private JDBCParamsParser() {
    }

    public static JDBCParamsParser getInstance() {
        return INSTANCE;
    }

    @Override
    public List<Object> newParams() {
        return new ArrayList<Object>();
    }

    @Override
    public void parse(StringBuilder scriptBuilder, Map<String, ?> params, String paramName, List<Object> targetParams) {
        scriptBuilder.append('?');
        Object value = params.get(paramName);
        if (value != null) {
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                if (CollectionUtils.isEmpty(c)) {
                    targetParams.add(null);
                } else {
                    Iterator it = c.iterator();
                    targetParams.add(it.next());
                    while (it.hasNext()) {
                        scriptBuilder.append(',').append(' ').append('?');
                        targetParams.add(it.next());
                    }
                }
            } else if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                if (objects.length == 0) {
                    targetParams.add(null);
                } else {
                    targetParams.add(objects[0]);
                    for (int i = 1; i < objects.length; ++i) {
                        scriptBuilder.append(',').append(' ').append('?');
                        targetParams.add(objects[i]);
                    }
                }
            } else {
                targetParams.add(value);
            }
        } else {
            targetParams.add(value);
        }
    }
}

