/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.utils;

import cn.tenmg.dsl.utils.ObjectUtils;
import cn.tenmg.dsl.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class PlaceHolderUtils {
    private static final char[] PLACEHOLDER_PREFIX = new char[]{'$', '{'};
    private static final char PLACEHOLDER_SUFFIX = '}';
    private static final String PLACEHOLDER_REGEX = "[\\s\\S]*\\$\\{[^}]+\\}[\\s\\S]*";

    private PlaceHolderUtils() {
    }

    public static String replace(String tpl, CharSequence ... params) {
        HashMap<CharSequence, CharSequence> map;
        if (params != null) {
            map = new HashMap(params.length / 2);
            for (int i = 0; i < params.length; i += 2) {
                map.put(params[i], params[i + 1]);
            }
        } else {
            map = new HashMap<CharSequence, CharSequence>();
        }
        return PlaceHolderUtils.replace(tpl, map);
    }

    public static String replace(String tpl, Map<?, ?> params) {
        if (StringUtils.isBlank(tpl)) {
            return tpl;
        }
        if (params == null) {
            params = new HashMap();
        }
        int len = tpl.length();
        int deep = 0;
        char b = ' ';
        boolean isPlaceHolder = false;
        StringBuilder sb = new StringBuilder();
        HashMap<Integer, StringBuilder> placeHolderKey = new HashMap<Integer, StringBuilder>();
        for (int i = 0; i < len; ++i) {
            char c = tpl.charAt(i);
            if (isPlaceHolder) {
                if (PlaceHolderUtils.isPlaceHolderEnd(c)) {
                    if (deep < 2) {
                        isPlaceHolder = false;
                        PlaceHolderUtils.replace(sb, ((StringBuilder)placeHolderKey.get(deep)).toString(), params);
                    } else {
                        PlaceHolderUtils.replace((StringBuilder)placeHolderKey.get(deep - 1), ((StringBuilder)placeHolderKey.get(deep)).toString(), params);
                    }
                    --deep;
                } else if (PlaceHolderUtils.isPlaceHolderBegin(b, c)) {
                    ((StringBuilder)placeHolderKey.get(deep)).deleteCharAt(((StringBuilder)placeHolderKey.get(deep)).length() - 1);
                    placeHolderKey.put(++deep, new StringBuilder());
                } else {
                    ((StringBuilder)placeHolderKey.get(deep)).append(c);
                }
            } else if (PlaceHolderUtils.isPlaceHolderBegin(b, c)) {
                isPlaceHolder = true;
                sb.deleteCharAt(sb.length() - 1);
                placeHolderKey.put(++deep, new StringBuilder());
            } else {
                sb.append(c);
            }
            b = c;
        }
        return sb.toString();
    }

    private static void replace(StringBuilder sb, String key, Map<?, ?> params) {
        if (key.matches(PLACEHOLDER_REGEX)) {
            sb.append(PlaceHolderUtils.replace(key, params)).toString();
        } else {
            String defaultValue;
            String name;
            String[] keys = key.split(":", 2);
            if (keys.length > 1) {
                name = keys[0];
                defaultValue = keys[1];
            } else {
                name = keys[0];
                defaultValue = StringUtils.concat(Character.valueOf(PLACEHOLDER_PREFIX[0]), Character.valueOf(PLACEHOLDER_PREFIX[1]), key, Character.valueOf('}'));
            }
            Object value = ObjectUtils.getValueIgnoreException(params, name);
            if (value == null) {
                sb.append(defaultValue);
            } else {
                sb.append(value.toString());
            }
        }
    }

    private static boolean isPlaceHolderBegin(char b, char c) {
        return b == PLACEHOLDER_PREFIX[0] && c == PLACEHOLDER_PREFIX[1];
    }

    private static boolean isPlaceHolderEnd(char c) {
        return c == '}';
    }
}

