/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.converter;

import cn.tenmg.dsl.converter.AbstractParamsConverter;
import cn.tenmg.dsl.utils.DateUtils;
import cn.tenmg.dsl.utils.MapUtils;
import java.util.Date;
import java.util.Map;

public class DateAddParamsConverter
extends AbstractParamsConverter<Object> {
    private static final Map<String, Integer> fields = MapUtils.newHashMapBuilder(7, String.class, Integer.class).put("millisecond", 14).put("second", 13).put("minute", 12).put("hour", 10).put("day", 5).put("month", 2).build("year", 1);
    private int amount;
    private String unit = "day";

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public Object convert(Object value) {
        Integer field;
        if (value instanceof Date && (field = fields.get(this.unit)) != null) {
            return DateUtils.add((Date)value, field, this.amount);
        }
        return value;
    }

    public static final class Unit {
        public static final String MILLISECOND = "millisecond";
        public static final String SECOND = "second";
        public static final String MINUTE = "minute";
        public static final String HOUR = "hour";
        public static final String DAY = "day";
        public static final String MONTH = "month";
        public static final String YEAR = "year";
    }
}

