/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.macro;

import cn.tenmg.dsl.DSLContext;
import cn.tenmg.dsl.EvalEngine;
import cn.tenmg.dsl.Macro;
import cn.tenmg.dsl.eval.JavaScriptEngine;
import cn.tenmg.dsl.utils.ConfigUtils;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.MapUtils;
import cn.tenmg.dsl.utils.StringUtils;
import java.util.Map;

public abstract class EvalableMacro
implements Macro {
    private static final EvalEngine evalEngine = EvalableMacro.getEvalEngine();

    private static EvalEngine getEvalEngine() {
        EvalEngine evalEngine;
        String className = ConfigUtils.getProperty("macro.eval-engine");
        if (StringUtils.isBlank(className)) {
            evalEngine = new JavaScriptEngine();
        } else {
            try {
                evalEngine = (EvalEngine)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                evalEngine = new JavaScriptEngine();
            }
        }
        return evalEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(DSLContext context, Map<String, Object> attributes, String logic, StringBuilder dslf, Map<String, Object> params) throws Exception {
        try {
            evalEngine.open();
            if (MapUtils.isNotEmpty(params)) {
                evalEngine.put(params);
            }
            boolean bl = this.excute(evalEngine, context, attributes, logic, dslf);
            return bl;
        }
        finally {
            evalEngine.close();
        }
    }

    protected static String toEvalable(String code) {
        int backslashes = 0;
        boolean isString = false;
        boolean isParam = false;
        char a = ' ';
        char b = ' ';
        StringBuilder codeBuilder = new StringBuilder();
        int len = code.length();
        for (int i = 0; i < len; ++i) {
            char c = code.charAt(i);
            if (isString) {
                if (c == '\\') {
                    ++backslashes;
                } else {
                    if (DSLUtils.isStringEnd(a, b, c, backslashes)) {
                        isString = false;
                    }
                    backslashes = 0;
                }
                codeBuilder.append(c);
            } else if (isParam) {
                if (!DSLUtils.isParamChar(c)) {
                    isParam = false;
                }
                codeBuilder.append(c);
            } else if (DSLUtils.isParamBegin(a, b, c)) {
                isParam = true;
                codeBuilder.setCharAt(codeBuilder.length() - 1, c);
            } else {
                codeBuilder.append(c);
            }
            a = b;
            b = c;
        }
        return codeBuilder.toString();
    }

    abstract boolean excute(EvalEngine var1, DSLContext var2, Map<String, Object> var3, String var4, StringBuilder var5) throws Exception;
}

