/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.parser;

import cn.tenmg.dsl.ParamsParser;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class PlaintextParamsParser
implements ParamsParser<Void> {
    private static final String SINGLE_QUOTATION_MARK = "'";
    private static final String ENCODE_SINGLE_QUOTATION_MARK = "\\\\'";

    @Override
    public Void newParams() {
        return null;
    }

    @Override
    public void parse(StringBuilder scriptBuilder, Map<String, ?> params, String paramName, Void targetParams) {
        Object value = params.get(paramName);
        if (value == null) {
            PlaintextParamsParser.appendNull(scriptBuilder);
        } else if (value instanceof Collection) {
            Collection c = (Collection)value;
            if (c.isEmpty()) {
                PlaintextParamsParser.appendNull(scriptBuilder);
            } else {
                Iterator it = c.iterator();
                this.append(scriptBuilder, it.next());
                while (it.hasNext()) {
                    scriptBuilder.append(',').append(' ');
                    this.append(scriptBuilder, it.next());
                }
            }
        } else if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            if (objects.length == 0) {
                PlaintextParamsParser.appendNull(scriptBuilder);
            } else {
                this.append(scriptBuilder, objects[0]);
                for (int i = 1; i < objects.length; ++i) {
                    scriptBuilder.append(',').append(' ');
                    this.append(scriptBuilder, objects[i]);
                }
            }
        } else {
            this.append(scriptBuilder, value);
        }
    }

    private static final void appendNull(StringBuilder scriptBuilder) {
        scriptBuilder.append("null");
    }

    private static final void appendString(StringBuilder scriptBuilder, String value) {
        scriptBuilder.append(SINGLE_QUOTATION_MARK).append(value.replaceAll(SINGLE_QUOTATION_MARK, ENCODE_SINGLE_QUOTATION_MARK)).append(SINGLE_QUOTATION_MARK);
    }

    private void append(StringBuilder scriptBuilder, Object value) {
        if (value == null) {
            PlaintextParamsParser.appendNull(scriptBuilder);
        } else if (value instanceof String) {
            PlaintextParamsParser.appendString(scriptBuilder, (String)value);
        } else if (value instanceof CharSequence || value instanceof Character || value instanceof char[]) {
            PlaintextParamsParser.appendString(scriptBuilder, value.toString());
        } else if (value instanceof Number || value instanceof Boolean) {
            scriptBuilder.append(value);
        } else {
            scriptBuilder.append(this.convert(value));
        }
    }

    protected abstract String convert(Object var1);
}

