/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.utils;

import cn.tenmg.dsl.exception.NumberParseException;
import cn.tenmg.dsl.utils.StringUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DecimalUtils {
    private static final ConcurrentHashMap<String, NumberFormat> FORMATTERS = new ConcurrentHashMap();

    public static String format(Object obj, String pattern) {
        return DecimalUtils.formatter(pattern).format(obj);
    }

    public static Number parse(Object obj, String pattern) {
        String str;
        NumberFormat formatter = DecimalUtils.formatter(pattern);
        if (obj instanceof String) {
            try {
                return formatter.parse((String)obj);
            }
            catch (Exception e) {
                throw new NumberParseException(StringUtils.concat("An exception occurred when using the pattern: ", pattern, " to parse the String: ", obj, " to Number"), e);
            }
        }
        try {
            str = formatter.format(obj);
        }
        catch (Exception e) {
            throw new NumberParseException(StringUtils.concat("An exception occurred when using the pattern: ", pattern, " to format the Object: ", obj, " to String"), e);
        }
        try {
            return formatter.parse(str);
        }
        catch (Exception e) {
            throw new NumberParseException(StringUtils.concat("An exception occurred when using the pattern: ", pattern, " to parse the String: ", str, " to Number"), e);
        }
    }

    private static NumberFormat formatter(String pattern) {
        NumberFormat formatter = FORMATTERS.get(pattern);
        if (formatter == null) {
            formatter = new DecimalFormat(pattern);
            FORMATTERS.put(pattern, formatter);
        }
        return formatter;
    }
}

