/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.utils;

import cn.tenmg.dsl.utils.MapUtils;
import cn.tenmg.dsl.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ObjectUtils {
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[[^\\]]+\\]");
    private static final Pattern ARRAY_END_PATTERN = Pattern.compile("\\[[^\\]]+\\]$");
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String METHOD_RETURNTYPE_SPLITOR = ":";
    private static volatile Map<Class<?>, Map<String, Field>> fieldMap = new HashMap(128);
    private static volatile Map<Class<?>, Map<String, Method>> getMethodMap = new HashMap(128);
    private static volatile Map<Class<?>, Map<String, List<Method>>> setMethodMap = new HashMap(128);
    private static volatile Map<Class<?>, Map<String, Method>> bestSetMethodMap = new HashMap(128);

    private ObjectUtils() {
    }

    public static <T> T getValue(Object object, String attribute) throws Exception {
        Object value = ObjectUtils.getValueInner(object, attribute);
        if (value == null) {
            String[] names = attribute.split("\\.", 2);
            if (names.length > 1) {
                attribute = names[0];
                value = ObjectUtils.getValueInner(object, attribute);
                if (value == null) {
                    return ObjectUtils.getMaybeArrayOrMapValue(object, attribute);
                }
                names = names[1].split("\\.");
                for (int i = 0; i < names.length; ++i) {
                    attribute = names[i];
                    if ((value = ObjectUtils.getValue(value, attribute)) != null) continue;
                    Matcher m = ARRAY_PATTERN.matcher(attribute);
                    if (m.find()) {
                        if ((value = ObjectUtils.getValue(value, attribute.substring(0, attribute.indexOf("[")))) == null) {
                            return null;
                        }
                        value = ObjectUtils.getArrayOrMapValue(value, m);
                    }
                    return (T)value;
                }
                return (T)value;
            }
            return ObjectUtils.getMaybeArrayOrMapValue(object, attribute);
        }
        return (T)value;
    }

    public static <T> T getValueIgnoreException(Object object, String attribute) {
        T value = null;
        try {
            value = ObjectUtils.getValue(object, attribute);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static Class<?> getFieldType(Object object, String fieldName) {
        return ObjectUtils.getFieldType(object, fieldName, true);
    }

    public static Class<?> getFieldType(Object object, String fieldName, boolean throwWhenAbsent) {
        Class<?> type = object.getClass();
        String methodName = ObjectUtils.toMethodName(SET, fieldName);
        List<Method> methods = ObjectUtils.getSetMethods(type).get(methodName);
        if (methods == null) {
            Field field = ObjectUtils.getFields(type, object).get(fieldName);
            if (field == null) {
                if (throwWhenAbsent) {
                    throw new IllegalArgumentException(StringUtils.concat("There is no suitable method named ", methodName, " or field named ", fieldName, " in class ", type.getName()));
                }
                return null;
            }
            return field.getType();
        }
        int size = methods.size();
        if (size == 1) {
            return methods.get(0).getParameterTypes()[0];
        }
        Field field = ObjectUtils.getFields(type, object).get(fieldName);
        if (field == null) {
            if (throwWhenAbsent) {
                throw new IllegalArgumentException(StringUtils.concat("There is no field named ", fieldName, " and more than one set method named ", methodName, " in class ", type.getName(), ", we don't know which one to use for getting field type"));
            }
            return null;
        }
        return field.getType();
    }

    public static <T> void setValue(Object object, String attribute, T value) throws Exception {
        ObjectUtils.setValue(object, attribute, value, true);
    }

    public static <T> void setValue(Object object, String attribute, T value, boolean throwWhenAbsent) throws Exception {
        Matcher matcher = ARRAY_END_PATTERN.matcher(attribute);
        if (matcher.find()) {
            String group = matcher.group();
            ObjectUtils.setValue(object, attribute.substring(0, attribute.length() - group.length()), group.substring(1, group.length() - 1), value, throwWhenAbsent);
        } else {
            int index = attribute.lastIndexOf(".");
            if (index > 0) {
                ObjectUtils.setValue(object, attribute.substring(0, index), attribute.substring(index + 1), value, throwWhenAbsent);
            } else {
                ObjectUtils.setValueInner(object, attribute, value, throwWhenAbsent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T clone(T obj) throws IOException {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream bo = null;
        ObjectOutputStream oo = null;
        ByteArrayInputStream bi = null;
        ObjectInputStream oi = null;
        try {
            Object object;
            bo = new ByteArrayOutputStream();
            oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            bi = new ByteArrayInputStream(bo.toByteArray());
            oi = new ObjectInputStream(bi);
            try {
                object = oi.readObject();
            }
            catch (ClassNotFoundException e) {
                T t;
                block14: {
                    t = null;
                    if (bo == null) break block14;
                    bo.close();
                }
                if (oo != null) {
                    oo.close();
                }
                if (bi != null) {
                    bi.close();
                }
                if (oi != null) {
                    oi.close();
                }
                return t;
            }
            return (T)object;
        }
        finally {
            if (bo != null) {
                bo.close();
            }
            if (oo != null) {
                oo.close();
            }
            if (bi != null) {
                bi.close();
            }
            if (oi != null) {
                oi.close();
            }
        }
    }

    private static Object getValueInner(Object object, String fieldName) throws Exception {
        if (object instanceof Map) {
            return ((Map)object).get(fieldName);
        }
        if (object instanceof List) {
            return ((List)object).get(ObjectUtils.toIndex(fieldName));
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[ObjectUtils.toIndex(fieldName)];
        }
        if (object instanceof int[]) {
            return ((int[])object)[ObjectUtils.toIndex(fieldName)];
        }
        if (object instanceof long[]) {
            return ((long[])object)[ObjectUtils.toIndex(fieldName)];
        }
        if (object instanceof double[]) {
            return ((double[])object)[ObjectUtils.toIndex(fieldName)];
        }
        if (object instanceof float[]) {
            return Float.valueOf(((float[])object)[ObjectUtils.toIndex(fieldName)]);
        }
        if (object instanceof short[]) {
            return ((short[])object)[ObjectUtils.toIndex(fieldName)];
        }
        if (object instanceof char[]) {
            return Character.valueOf(((char[])object)[ObjectUtils.toIndex(fieldName)]);
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object)[ObjectUtils.toIndex(fieldName)];
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[ObjectUtils.toIndex(fieldName)];
        }
        if (object instanceof LinkedHashSet) {
            return ((LinkedHashSet)object).toArray()[ObjectUtils.toIndex(fieldName)];
        }
        Class<?> type = object.getClass();
        Method method = ObjectUtils.getGetMethods(type).get(ObjectUtils.toMethodName(GET, fieldName));
        if (method == null) {
            Field field = ObjectUtils.getFields(type, object).get(fieldName);
            if (field == null) {
                return null;
            }
            return field.get(object);
        }
        return method.invoke(object, new Object[0]);
    }

    private static int toIndex(String expr) {
        if (expr.startsWith("[") && expr.endsWith("]")) {
            return Integer.valueOf(expr.substring(1, expr.length() - 1).trim());
        }
        return Integer.valueOf(expr.trim());
    }

    private static String toMethodName(String prefix, String fieldName) {
        return prefix + (fieldName.length() > 1 ? fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1) : fieldName.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Method> getGetMethods(Class<?> type) {
        Map<String, Method> getMethods = getMethodMap.get(type);
        if (getMethods == null) {
            Map<Class<?>, Map<String, Method>> map = getMethodMap;
            synchronized (map) {
                getMethods = getMethodMap.get(type);
                if (getMethods == null) {
                    getMethods = new HashMap<String, Method>(128);
                    Method[] mthds = type.getMethods();
                    for (int i = 0; i < mthds.length; ++i) {
                        Method method = mthds[i];
                        String name = method.getName();
                        int count = method.getParameterCount();
                        if (count != 0) continue;
                        if (name.startsWith(GET)) {
                            getMethods.put(name, method);
                            continue;
                        }
                        if (name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2)) && Boolean.class.isAssignableFrom(method.getReturnType())) {
                            getMethods.put(GET.concat(name.substring(2)), method);
                            continue;
                        }
                        getMethods.put(GET.concat(name), method);
                    }
                    getMethodMap.put(type, getMethods);
                }
            }
        }
        return getMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, List<Method>> getSetMethods(Class<?> type) {
        Map<String, List<Method>> methods = setMethodMap.get(type);
        if (methods == null) {
            Map<Class<?>, Map<String, List<Method>>> map = setMethodMap;
            synchronized (map) {
                methods = setMethodMap.get(type);
                if (methods == null) {
                    methods = new HashMap<String, List<Method>>(128);
                    Method[] mthds = type.getMethods();
                    for (int i = 0; i < mthds.length; ++i) {
                        Method method = mthds[i];
                        String name = method.getName();
                        int count = method.getParameterCount();
                        if (count != 1 || !name.startsWith(SET)) continue;
                        List<Method> setMethods = methods.get(name);
                        if (setMethods == null) {
                            setMethods = new ArrayList<Method>();
                            methods.put(name, setMethods);
                        }
                        setMethods.add(method);
                    }
                    setMethodMap.put(type, methods);
                }
            }
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Method getBestSetMethod(Class<?> type, List<Method> setMethods, String methodName, T value) {
        Map<String, Method> bestSetMethods = bestSetMethodMap.get(type);
        if (bestSetMethods == null) {
            Map<Class<?>, Map<String, Method>> map = bestSetMethodMap;
            synchronized (map) {
                bestSetMethods = bestSetMethodMap.get(type);
                if (bestSetMethods == null) {
                    bestSetMethods = new HashMap<String, Method>(128);
                    bestSetMethodMap.put(type, bestSetMethods);
                }
                return ObjectUtils.getBestSetMethod(bestSetMethods, setMethods, methodName, value);
            }
        }
        Map<String, Method> map = bestSetMethods;
        synchronized (map) {
            return ObjectUtils.getBestSetMethod(bestSetMethods, setMethods, methodName, value);
        }
    }

    private static <T> Method getBestSetMethod(Map<String, Method> bestSetMethods, List<Method> setMethods, String methodName, T value) {
        Method bestSetMethod = null;
        if (value == null) {
            if (bestSetMethods.containsKey(methodName)) {
                bestSetMethod = bestSetMethods.get(methodName);
            } else {
                int size = setMethods.size();
                for (int i = 0; i < size; ++i) {
                    Method curMethod = setMethods.get(i);
                    if (!Object.class.isAssignableFrom(curMethod.getParameterTypes()[0])) continue;
                    bestSetMethod = curMethod;
                }
                bestSetMethods.put(methodName, bestSetMethod);
            }
        } else {
            Class<?> valueType = value.getClass();
            String bestKey = String.join((CharSequence)METHOD_RETURNTYPE_SPLITOR, methodName, valueType.getName());
            if (bestSetMethods.containsKey(bestKey)) {
                bestSetMethod = bestSetMethods.get(bestKey);
            } else {
                int minGeneration = Integer.MAX_VALUE;
                int size = setMethods.size();
                for (int i = 0; i < size; ++i) {
                    Method curMethod = setMethods.get(i);
                    Class<?> parameterType = curMethod.getParameterTypes()[0];
                    if (parameterType.equals(valueType)) {
                        bestSetMethod = curMethod;
                        break;
                    }
                    if (!parameterType.isAssignableFrom(valueType)) continue;
                    int generation = 1;
                    while (!parameterType.equals(valueType)) {
                        valueType = valueType.getSuperclass();
                        ++generation;
                    }
                    if (generation >= minGeneration) continue;
                    bestSetMethod = curMethod;
                }
                bestSetMethods.put(bestKey, bestSetMethod);
            }
        }
        return bestSetMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Field> getFields(Class<?> type, Object object) {
        Map<String, Field> fields = fieldMap.get(type);
        if (fields == null) {
            Map<Class<?>, Map<String, Field>> map = fieldMap;
            synchronized (map) {
                fields = fieldMap.get(type);
                if (fields == null) {
                    fields = new HashMap<String, Field>();
                    Set<String> excludedFields = ObjectUtils.getExcludedFields(type);
                    while (!type.equals(Object.class)) {
                        Field[] declaredFields = type.getDeclaredFields();
                        for (int i = 0; i < declaredFields.length; ++i) {
                            Field field = declaredFields[i];
                            String fieldName = field.getName();
                            if (excludedFields.contains(fieldName)) continue;
                            if (!Modifier.isFinal(field.getModifiers())) {
                                try {
                                    field.getClass().getMethod("trySetAccessible", new Class[0]).invoke((Object)field, new Object[0]);
                                }
                                catch (NoSuchMethodException e) {
                                    try {
                                        if (!((Boolean)field.getClass().getMethod("isAccessible", new Class[0]).invoke((Object)field, new Object[0])).booleanValue()) {
                                            field.setAccessible(true);
                                        }
                                    }
                                    catch (Exception exception) {}
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            fields.put(field.getName(), field);
                        }
                        type = type.getSuperclass();
                    }
                    fieldMap.put(type, fields);
                }
            }
        }
        return fields;
    }

    private static Set<String> getExcludedFields(Class<?> type) {
        Map<String, List<Method>> setMethods;
        HashSet<String> excludedFields = new HashSet<String>();
        Map<String, Method> getMethods = ObjectUtils.getGetMethods(type);
        if (MapUtils.isNotEmpty(getMethods) && MapUtils.isNotEmpty(setMethods = ObjectUtils.getSetMethods(type))) {
            Iterator<String> it = getMethods.keySet().iterator();
            while (it.hasNext()) {
                String fieldName = it.next().substring(3);
                if (!setMethods.containsKey(SET.concat(fieldName))) continue;
                excludedFields.add(StringUtils.toCamelCase(fieldName, null, false));
            }
        }
        return excludedFields;
    }

    private static final <T> T getMaybeArrayOrMapValue(Object object, String attribute) throws Exception {
        Object value = null;
        Matcher m = ARRAY_PATTERN.matcher(attribute);
        if (m.find()) {
            String parentAttribute = attribute.substring(0, attribute.indexOf("["));
            value = parentAttribute.isEmpty() ? object : ObjectUtils.getValueInner(object, parentAttribute);
            if (value == null) {
                return null;
            }
            value = ObjectUtils.getArrayOrMapValue(value, m);
        }
        return (T)value;
    }

    private static final <T> T getArrayOrMapValue(Object value, Matcher m) throws Exception {
        value = ObjectUtils.getArrayOrMapValue(value, m.group());
        while (value != null && m.find()) {
            value = ObjectUtils.getArrayOrMapValue(value, m.group());
        }
        return (T)value;
    }

    private static final Object getArrayOrMapValue(Object value, String group) throws Exception {
        String key = group.substring(1, group.length() - 1);
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.containsKey(key)) {
                return map.get(key);
            }
            return map.get(StringUtils.decode(key));
        }
        if (value instanceof List) {
            return ((List)value).get(Integer.valueOf(key));
        }
        if (value instanceof Object[]) {
            return ((Object[])value)[Integer.valueOf(key)];
        }
        if (value instanceof int[]) {
            return ((int[])value)[Integer.valueOf(key)];
        }
        if (value instanceof long[]) {
            return ((long[])value)[Integer.valueOf(key)];
        }
        if (value instanceof double[]) {
            return ((double[])value)[Integer.valueOf(key)];
        }
        if (value instanceof float[]) {
            return Float.valueOf(((float[])value)[Integer.valueOf(key)]);
        }
        if (value instanceof short[]) {
            return ((short[])value)[Integer.valueOf(key)];
        }
        if (value instanceof char[]) {
            return Character.valueOf(((char[])value)[Integer.valueOf(key)]);
        }
        if (value instanceof boolean[]) {
            return ((boolean[])value)[Integer.valueOf(key)];
        }
        if (value instanceof byte[]) {
            return ((byte[])value)[Integer.valueOf(key)];
        }
        if (value instanceof LinkedHashSet) {
            return ((LinkedHashSet)value).toArray()[Integer.valueOf(key)];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void setValue(Object object, String parentAttribute, String attribute, Object value, boolean throwWhenAbsent) throws Exception {
        int size;
        if (StringUtils.isBlank(parentAttribute)) {
            ObjectUtils.setValueInner(object, attribute, value, throwWhenAbsent);
            return;
        }
        Object t = ObjectUtils.getValue(object, parentAttribute);
        if (t != null) {
            ObjectUtils.setValueInner(t, attribute, value, throwWhenAbsent);
            return;
        }
        if (object instanceof Map) {
            ((Map)object).put(attribute, value);
            return;
        }
        if (object instanceof List) {
            int index = Integer.valueOf(attribute);
            List list = (List)object;
            while (true) {
                if (list.size() > index) {
                    list.set(index, value);
                    return;
                }
                list.add(null);
            }
        }
        if (object instanceof Object[]) {
            ((Object[])object)[Integer.valueOf((String)attribute).intValue()] = value;
            return;
        }
        if (object instanceof int[]) {
            ((int[])object)[Integer.valueOf((String)attribute).intValue()] = (Integer)value;
            return;
        }
        if (object instanceof long[]) {
            ((long[])object)[Integer.valueOf((String)attribute).intValue()] = (Long)value;
            return;
        }
        if (object instanceof double[]) {
            ((double[])object)[Integer.valueOf((String)attribute).intValue()] = (Double)value;
            return;
        }
        if (object instanceof float[]) {
            ((float[])object)[Integer.valueOf((String)attribute).intValue()] = ((Float)value).floatValue();
            return;
        }
        if (object instanceof short[]) {
            ((short[])object)[Integer.valueOf((String)attribute).intValue()] = (Short)value;
            return;
        }
        if (object instanceof char[]) {
            ((char[])object)[Integer.valueOf((String)attribute).intValue()] = ((Character)value).charValue();
            return;
        }
        if (object instanceof boolean[]) {
            ((boolean[])object)[Integer.valueOf((String)attribute).intValue()] = (Boolean)value;
            return;
        }
        if (object instanceof byte[]) {
            ((byte[])object)[Integer.valueOf((String)attribute).intValue()] = (Byte)value;
            return;
        }
        if (!(object instanceof LinkedHashSet)) {
            Object object2 = ObjectUtils.getParent(object, parentAttribute, throwWhenAbsent);
            ObjectUtils.setValueInner(object2, attribute, value, throwWhenAbsent);
            return;
        }
        LinkedHashSet set = (LinkedHashSet)object;
        int index = Integer.valueOf(attribute);
        if (index < (size = set.size())) {
            int i;
            Object[] elms = set.toArray();
            set.clear();
            for (i = 0; i < index; ++i) {
                set.add(elms[i]);
            }
            set.add(value);
            i = index;
            while (i < size) {
                set.add(elms[i]);
                ++i;
            }
            return;
        }
        if (index == size) {
            set.add(value);
            return;
        }
        if (size > 1) {
            throw new IllegalArgumentException(StringUtils.concat("Trying to add an element at the index ", index, ", but there is only ", size, " elements in ", set.toString()));
        }
        throw new IllegalArgumentException(StringUtils.concat("Trying to add an element at the index ", index, ", but there is ", size > 0 ? "only 1" : "no", " element in ", set.toString()));
    }

    private static void setValueInner(Object object, String fieldName, Object value, boolean throwWhenAbsent) throws Exception {
        if (object instanceof Map) {
            ((Map)object).put(fieldName, value);
        } else {
            Class<?> type = object.getClass();
            String methodName = ObjectUtils.toMethodName(SET, fieldName);
            List<Method> methods = ObjectUtils.getSetMethods(type).get(methodName);
            if (methods == null) {
                Field field = ObjectUtils.getFields(type, object).get(fieldName);
                if (field == null) {
                    if (throwWhenAbsent) {
                        throw new IllegalArgumentException(StringUtils.concat("There is no suitable method named ", methodName, " or field named ", fieldName, " in class ", type.getName()));
                    }
                } else {
                    field.set(object, value);
                }
            } else {
                int size = methods.size();
                if (size == 1) {
                    methods.get(0).invoke(object, value);
                } else {
                    Method method = ObjectUtils.getBestSetMethod(type, methods, methodName, value);
                    if (method == null) {
                        Field field = ObjectUtils.getFields(type, object).get(fieldName);
                        if (field == null) {
                            if (throwWhenAbsent) {
                                throw new IllegalArgumentException(StringUtils.concat("There is no suitable method named ", methodName, " or field named ", fieldName, " in class ", type.getName()));
                            }
                        } else {
                            field.set(object, value);
                        }
                    } else {
                        method.invoke(object, value);
                    }
                }
            }
        }
    }

    private static Object getParent(Object object, String attribute, boolean throwWhenAbsent) throws Exception {
        Object parent = object;
        Matcher matcher = ARRAY_END_PATTERN.matcher(attribute);
        if (matcher.find()) {
            String group = matcher.group();
            parent = ObjectUtils.getParent(object, attribute.substring(0, attribute.length() - group.length()), group.substring(1, group.length() - 1), throwWhenAbsent);
        } else {
            int index = attribute.lastIndexOf(".");
            if (index > 0) {
                parent = ObjectUtils.getParent(object, attribute.substring(0, index), attribute.substring(index + 1), throwWhenAbsent);
            }
        }
        return parent;
    }

    private static Object getParent(Object object, String parentAttribute, String attribute, boolean throwWhenAbsent) throws Exception {
        if (StringUtils.isBlank(parentAttribute)) {
            return object;
        }
        Object parent = ObjectUtils.getValue(object, parentAttribute);
        if (parent == null) {
            parent = ObjectUtils.getParent(object, parentAttribute, throwWhenAbsent);
            ObjectUtils.setValueInner(object, attribute, parent, throwWhenAbsent);
        } else {
            Class<?> type = parent.getClass();
            String methodName = ObjectUtils.toMethodName(SET, attribute);
            List<Method> setMethods = ObjectUtils.getSetMethods(type).get(methodName);
            if (setMethods == null) {
                Field field = ObjectUtils.getFields(type, parent).get(attribute);
                if (field == null) {
                    if (throwWhenAbsent) {
                        throw new IllegalArgumentException(StringUtils.concat("There is no set method named ", methodName, " or field named ", attribute, " in class ", type.getName()));
                    }
                } else {
                    Object grandparent = parent;
                    parent = field.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                    ObjectUtils.setValueInner(grandparent, attribute, parent, throwWhenAbsent);
                }
            } else {
                int count = setMethods.size();
                if (count == 1) {
                    Object grandparent = parent;
                    parent = setMethods.get(0).getParameterTypes()[0].getConstructor(new Class[0]).newInstance(new Object[0]);
                    ObjectUtils.setValueInner(grandparent, attribute, parent, throwWhenAbsent);
                } else {
                    throw new IllegalArgumentException(StringUtils.concat("Due to the feild ", attribute, " is null and there is ", count, " set methods named ", methodName, " for it in class ", type.getName(), ", we don't know which one to use for instantiation"));
                }
            }
        }
        return parent;
    }
}

