/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.utils;

import cn.tenmg.dsl.DSLContext;
import cn.tenmg.dsl.Macro;
import cn.tenmg.dsl.exception.MacroException;
import cn.tenmg.dsl.utils.ConfigUtils;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.FileUtils;
import cn.tenmg.dsl.utils.StringUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class MacroUtils {
    private static final String MACRO_KEY_PREFIX = "macro.";
    private static final String CLASS_SUFFIX = ".class";
    private static final String SCAN_PACKAGES_KEY = "scan.packages";
    private static final char MACRO_LOGIC_START = '(';
    private static final char MACRO_LOGIC_END = ')';
    private static final Map<String, String> macros = new HashMap<String, String>();
    private static final Map<String, Macro> MACROS = new HashMap<String, Macro>();

    private MacroUtils() {
    }

    public static final Dslf execute(DSLContext context, Map<String, Object> attributes, StringBuilder dsl, Map<String, Object> params, boolean emptyWhenNoMacro) {
        int len = dsl.length();
        int backslashes = 0;
        char a = ' ';
        char b = ' ';
        StringBuilder macroNameBuilder = new StringBuilder();
        StringBuilder paramNameBuilder = null;
        HashMap<String, Object> usedParams = new HashMap<String, Object>();
        for (int i = 0; i < len; ++i) {
            char c = dsl.charAt(i);
            if (c == '(') {
                if (macroNameBuilder.length() > 0) {
                    String macroName = macroNameBuilder.toString();
                    Macro macro = MacroUtils.getMacro(macroName);
                    if (macro == null) {
                        if (emptyWhenNoMacro) {
                            dsl.setLength(0);
                        }
                        return MacroUtils.newDslf(dsl, false);
                    }
                    StringBuilder logic = new StringBuilder();
                    boolean isString = false;
                    boolean isParam = false;
                    int deep = 0;
                    while (++i < len) {
                        a = b;
                        b = c;
                        c = dsl.charAt(i);
                        if (isString) {
                            if (c == '\\') {
                                ++backslashes;
                            } else {
                                if (DSLUtils.isStringEnd(a, b, c, backslashes)) {
                                    isString = false;
                                }
                                backslashes = 0;
                            }
                            logic.append(c);
                            continue;
                        }
                        if (c == ')') {
                            if (deep == 0) {
                                if (logic.length() > 0) {
                                    try {
                                        return MacroUtils.newDslf(dsl, macro.execute(context, attributes, logic.toString(), dsl.delete(0, i + 1), usedParams));
                                    }
                                    catch (Exception e) {
                                        throw new MacroException("Exception occurred when executing macro ".concat(macroName), e);
                                    }
                                }
                                return MacroUtils.newDslf(dsl, false);
                            }
                            logic.append(c);
                            --deep;
                            continue;
                        }
                        if (c == '(') {
                            logic.append(c);
                            ++deep;
                            continue;
                        }
                        if (isParam) {
                            if (DSLUtils.isParamChar(c)) {
                                paramNameBuilder.append(c);
                            } else {
                                isParam = false;
                                String paramName = paramNameBuilder.toString();
                                usedParams.put(paramName, params.get(paramName));
                            }
                        } else if (DSLUtils.isParamBegin(a, b, c)) {
                            isParam = true;
                            paramNameBuilder = new StringBuilder().append(c);
                        }
                        logic.append(c);
                    }
                    return MacroUtils.newDslf(dsl, false);
                }
                if (emptyWhenNoMacro) {
                    dsl.setLength(0);
                }
                return MacroUtils.newDslf(dsl, false);
            }
            if (c <= ' ') {
                if (macroNameBuilder.length() > 0) {
                    String macroName = macroNameBuilder.toString();
                    Macro macro = MacroUtils.getMacro(macroName);
                    if (macro == null) {
                        if (emptyWhenNoMacro) {
                            dsl.setLength(0);
                        }
                        return MacroUtils.newDslf(dsl, false);
                    }
                    try {
                        return MacroUtils.newDslf(dsl, macro.execute(context, attributes, null, dsl.delete(0, i), usedParams));
                    }
                    catch (Exception e) {
                        throw new MacroException("An exception occurred when executing macro ".concat(macroName), e);
                    }
                }
                if (emptyWhenNoMacro) {
                    dsl.setLength(0);
                }
                return MacroUtils.newDslf(dsl, false);
            }
            macroNameBuilder.append(c);
            a = b;
            b = c;
        }
        if (emptyWhenNoMacro) {
            dsl.setLength(0);
        }
        return MacroUtils.newDslf(dsl, false);
    }

    private static final Dslf newDslf(StringBuilder value, boolean dslfAsScript) {
        return new Dslf(value, dslfAsScript);
    }

    private static String getMacroName(Class<?> type) {
        cn.tenmg.dsl.annotion.Macro macro = type.getAnnotation(cn.tenmg.dsl.annotion.Macro.class);
        if (macro != null) {
            String name = macro.name();
            if (StringUtils.isBlank(name)) {
                name = macro.value();
            }
            return StringUtils.isBlank(name) ? type.getSimpleName().toLowerCase() : name;
        }
        return type.getSimpleName().toLowerCase();
    }

    private static void scanMacros(String basePackage, int suffixLen) throws IOException, ClassNotFoundException {
        List<String> paths = FileUtils.scanPackage(basePackage, CLASS_SUFFIX);
        if (paths != null) {
            int size = paths.size();
            for (int i = 0; i < size; ++i) {
                cn.tenmg.dsl.annotion.Macro macro;
                String className = paths.get(i);
                Class<?> c = Class.forName(className = className.substring(0, className.length() - suffixLen).replaceAll("/", "."));
                if (!Macro.class.isAssignableFrom(c) || (macro = c.getAnnotation(cn.tenmg.dsl.annotion.Macro.class)) == null) continue;
                String name = macro.name();
                macros.put(StringUtils.isBlank(name) ? c.getSimpleName().toLowerCase() : name, className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Macro getMacro(String name) {
        Macro macro = MACROS.get(name);
        if (macro == null) {
            Map<String, Macro> map = MACROS;
            synchronized (map) {
                macro = MACROS.get(name);
                if (macro == null) {
                    String className;
                    String string = className = macros.containsKey(name) ? macros.get(name) : ConfigUtils.getProperty(MACRO_KEY_PREFIX + name);
                    if (StringUtils.isNotBlank(className)) {
                        try {
                            macro = (Macro)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            MACROS.put(name, macro);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            throw new IllegalArgumentException("Cannot instantiate Macro for name '" + name + "'", e);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Wrong Macro configuration for name " + name + "'", e);
                        }
                    }
                }
            }
        }
        return macro;
    }

    static {
        ServiceLoader<Macro> loader = ServiceLoader.load(Macro.class);
        for (Macro macro : loader) {
            MACROS.put(MacroUtils.getMacroName(macro.getClass()), macro);
        }
        try {
            int suffixLen = CLASS_SUFFIX.length();
            MacroUtils.scanMacros("cn.tenmg.dsl.macro", suffixLen);
            String scanPackages = ConfigUtils.getProperty(SCAN_PACKAGES_KEY);
            if (scanPackages != null) {
                String[] basePackages = scanPackages.split(",");
                for (int i = 0; i < basePackages.length; ++i) {
                    MacroUtils.scanMacros(basePackages[i].trim(), suffixLen);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Dslf {
        private StringBuilder value;
        private boolean dslfAsScript;

        public StringBuilder getValue() {
            return this.value;
        }

        public boolean isDslfAsScript() {
            return this.dslfAsScript;
        }

        public Dslf(StringBuilder value, boolean dslfAsScript) {
            this.value = value;
            this.dslfAsScript = dslfAsScript;
        }
    }
}

