/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.eval;

import cn.tenmg.dsl.EvalEngine;
import cn.tenmg.dsl.exception.MacroException;
import cn.tenmg.dsl.utils.MapUtils;
import cn.tenmg.dsl.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class JavaScriptEngine
implements EvalEngine {
    private static final ScriptEngineManager SCRIPT_ENGINE_MANAGER = new ScriptEngineManager();
    private ThreadLocal<ScriptEngine> scriptEngineHolder = new ThreadLocal();

    @Override
    public void open() {
        this.scriptEngineHolder.set(JavaScriptEngine.getJavaScriptEngine());
    }

    @Override
    public void put(Map<String, Object> params) {
        ScriptEngine scriptEngine = this.scriptEngineHolder.get();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String decode;
            String name = entry.getKey();
            Key[] keys = JavaScriptEngine.toKeys(entry.getKey());
            if (keys.length == 1) {
                scriptEngine.put(name, entry.getValue());
                continue;
            }
            HashMap<String, Object> value = MapUtils.newHashMap();
            Key key = keys[0];
            JavaScriptEngine.checkName(params, key.fullName, name);
            scriptEngine.put(key.name, value);
            int last = keys.length - 1;
            for (int i = 1; i < last; ++i) {
                key = keys[i];
                JavaScriptEngine.checkName(params, key.fullName, name);
                decode = JavaScriptEngine.getEncodeName(params, keys, key, i, name);
                scriptEngine.put(decode, decode);
                HashMap child = MapUtils.newHashMap();
                value.put(decode, child);
                value = child;
            }
            key = keys[last];
            decode = JavaScriptEngine.getEncodeName(params, keys, key, last, name);
            scriptEngine.put(decode, decode);
            value.put(decode, entry.getValue());
        }
    }

    @Override
    public Object eval(String code) throws Exception {
        return this.scriptEngineHolder.get().eval(code);
    }

    @Override
    public void close() {
        this.scriptEngineHolder.remove();
    }

    private static void checkName(Map<String, Object> params, String fullName, String name) {
        if (params.containsKey(fullName)) {
            throw new MacroException(String.format("The parameter name '%s' is a part of another parameter name '%s' in the same macro, please change one of them to another name", fullName, name));
        }
    }

    private static String getEncodeName(Map<String, Object> params, Key[] keys, Key key, int index, String name) {
        String decode = StringUtils.decode(key.name);
        if (key.name.equals(decode) && params.containsKey(key.name)) {
            String prefix = keys[index - 1].fullName;
            throw new MacroException(String.format("The parameter name '%s' contains another parameter name '%s' in the same macro, please change to '%s['%s']%s' or '%s[\"%s\"]%s'", name, key.name, prefix, key.name, key.leftName, prefix, key.name, key.leftName));
        }
        return decode;
    }

    private static Key[] toKeys(String key) {
        boolean inSquare = false;
        ArrayList<Key> keys = new ArrayList<Key>();
        StringBuilder keyBuilder = new StringBuilder(key.substring(0, 1));
        int len = key.length();
        int last = len - 1;
        for (int i = 1; i < len; ++i) {
            char c = key.charAt(i);
            if (c == '.') {
                if (inSquare) {
                    keyBuilder.append(c);
                    while (++i < len && (c = key.charAt(i)) != ']') {
                        keyBuilder.append(c);
                    }
                    if (c != ']') continue;
                    inSquare = false;
                    keys.add(new Key(keyBuilder.substring(1), key.substring(0, i), key.substring(i)));
                    keyBuilder.setLength(0);
                    continue;
                }
                if (i < last) {
                    if (keyBuilder.length() <= 0) continue;
                    keys.add(new Key(keyBuilder.toString(), key.substring(0, i), key.substring(i)));
                    keyBuilder.setLength(0);
                    continue;
                }
                keys.add(new Key(keyBuilder.append(c).toString(), key.substring(0, i), key.substring(i)));
                continue;
            }
            if (c == '[') {
                if (keyBuilder.length() > 0) {
                    if (inSquare) {
                        keys.add(new Key(keyBuilder.substring(1), key.substring(0, i), key.substring(i)));
                        keyBuilder.setLength(0);
                    } else {
                        keys.add(new Key(keyBuilder.toString(), key.substring(0, i), key.substring(i)));
                        keyBuilder.setLength(0);
                    }
                }
                inSquare = true;
                keyBuilder.append(c);
                continue;
            }
            if (c == ']') {
                if (inSquare) {
                    inSquare = false;
                    keys.add(new Key(keyBuilder.substring(1), key.substring(0, i + 1), key.substring(i + 1)));
                    keyBuilder.setLength(0);
                    continue;
                }
                keyBuilder.append(c);
                continue;
            }
            keyBuilder.append(c);
        }
        if (keyBuilder.length() > 0) {
            keys.add(new Key(keyBuilder.toString(), key, ""));
        }
        return keys.toArray(new Key[0]);
    }

    private static ScriptEngine getJavaScriptEngine() {
        return SCRIPT_ENGINE_MANAGER.getEngineByName("JavaScript");
    }

    static {
        if (JavaScriptEngine.getJavaScriptEngine() == null) {
            throw new RuntimeException("Unable to find JavaScript engine, please import relevant components, such as nashorn-core");
        }
    }

    private static class Key {
        private String name;
        private String fullName;
        private String leftName;

        public Key(String name, String fullName, String leftName) {
            this.name = name;
            this.fullName = fullName;
            this.leftName = leftName;
        }
    }
}

