/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.filter;

import cn.tenmg.dsl.ParamsFilter;
import cn.tenmg.dsl.exception.TypeConvertException;
import cn.tenmg.dsl.utils.ConfigUtils;
import cn.tenmg.dsl.utils.MatchUtils;
import cn.tenmg.dsl.utils.StringUtils;

public abstract class CompareableParamsFilter
implements ParamsFilter {
    private static final boolean TYPE_CONVERT_EXCEPTION = Boolean.valueOf(ConfigUtils.getProperty("filter.type-convert-exception", "false"));
    private static final String TYPE_CONVERT_METHOD = "valueOf";
    private String params;
    private Object value;

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    abstract boolean decideNull();

    abstract <T extends Comparable<T>> boolean decide(T var1, T var2);

    @Override
    public boolean determine(String name, Object value) {
        if (StringUtils.isBlank(this.params)) {
            return false;
        }
        Object compared = this.getValue();
        if (compared == null) {
            if (value == null) {
                return this.decideNull();
            }
            return false;
        }
        if (MatchUtils.matchesAny(this.params.split(","), name)) {
            Class<?> type = value.getClass();
            Class<?> comparedType = compared.getClass();
            if (Comparable.class.isAssignableFrom(type)) {
                if (!type.equals(comparedType)) {
                    try {
                        compared = type.getMethod(TYPE_CONVERT_METHOD, comparedType).invoke(null, compared);
                    }
                    catch (Exception e) {
                        if (TYPE_CONVERT_EXCEPTION) {
                            throw new TypeConvertException(StringUtils.concat("An exception occured when converting compared value to the type of the parameter value by the static method ", TYPE_CONVERT_METHOD, "(", comparedType.getName(), ")"), e);
                        }
                        return false;
                    }
                }
                return this.decide((Comparable)value, (Comparable)compared);
            }
            return false;
        }
        return false;
    }
}

