/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.utils;

import cn.tenmg.dsl.DSLContext;
import cn.tenmg.dsl.NamedScript;
import cn.tenmg.dsl.ParamsConverter;
import cn.tenmg.dsl.ParamsFilter;
import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.context.DefaultDSLContext;
import cn.tenmg.dsl.utils.CollectionUtils;
import cn.tenmg.dsl.utils.ConfigUtils;
import cn.tenmg.dsl.utils.MacroUtils;
import cn.tenmg.dsl.utils.MapUtils;
import cn.tenmg.dsl.utils.ObjectUtils;
import cn.tenmg.dsl.utils.SetUtils;
import cn.tenmg.dsl.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DSLUtils {
    public static final char SINGLE_QUOTATION_MARK = '\'';
    public static final char BACKSLASH = '\\';
    public static final char BLANK_SPACE = ' ';
    public static final char COMMA = ',';
    public static final char PARAM_MARK = '?';
    public static final char[] DYNAMIC_PREFIX;
    public static final char DYNAMIC_SUFFIX;
    public static final char PARAM_PREFIX;
    public static final char EMBED_PREFIX;
    public static final char LINE_BREAK = '\n';
    public static final char[][] SINGLELINE_COMMENT_PREFIXES;
    public static final char[][] MILTILINE_COMMENT_PREFIXES;
    public static final char[][] MILTILINE_COMMENT_SUFFIXES;
    private static final char LEFT_SQUARE_BRACKET = '[';
    private static final char RIGHT_SQUARE_BRACKET = ']';
    private static DefaultDSLContext defaultDSLContext;
    private static final Set<Character> LINE_TAIL;
    private static final Set<Character> PARAM_CHARS;

    private DSLUtils() {
    }

    public static NamedScript parse(String dsl, Object ... params) {
        return DSLUtils.parse((DSLContext)defaultDSLContext, dsl, params);
    }

    public static NamedScript parse(String dsl, Object params) {
        return DSLUtils.parse((DSLContext)defaultDSLContext, dsl, params);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NamedScript parse(DSLContext context, String dsl, Object ... params) {
        HashMap<String, Object> paramsMap;
        if (params != null) {
            if (params.length % 2 != 0) throw new IllegalArgumentException("The number of parameters must be a multiple of 2");
            paramsMap = new HashMap(params.length / 2);
            for (int i = 0; i < params.length; ++i) {
                paramsMap.put((String)params[i], params[++i]);
            }
            return DSLUtils.parse(context, dsl, paramsMap);
        } else {
            paramsMap = new HashMap<String, Object>();
        }
        return DSLUtils.parse(context, dsl, paramsMap);
    }

    public static NamedScript parse(DSLContext context, String dsl, Object params) {
        HashMap<String, Object> usedParams = new HashMap<String, Object>();
        if (StringUtils.isBlank(dsl)) {
            return new NamedScript(dsl, usedParams);
        }
        int len = (dsl = DSLUtils.deleteStartBlankLines(StringUtils.stripEnd(dsl, null))).length();
        if (len < 3) {
            return new NamedScript(dsl, usedParams);
        }
        if (params == null) {
            params = new HashMap();
        }
        ParamGetter paramGetter = DSLUtils.getParamGetter(context);
        int deep = 0;
        int backslashes = 0;
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        boolean isSinglelineComment = false;
        boolean isMiltilineComment = false;
        boolean isDynamic = false;
        boolean isParam = false;
        boolean isEmbed = false;
        boolean notParamAccessor = true;
        StringBuilder scriptBuilder = new StringBuilder();
        StringBuilder paramNameBuilder = new StringBuilder();
        HashSet<Integer> containsInValidParams = new HashSet<Integer>();
        HashMap<Integer, Map<String, Object>> attributeses = new HashMap<Integer, Map<String, Object>>();
        HashMap<Integer, Map<String, Object>> validParamses = new HashMap<Integer, Map<String, Object>>();
        HashMap<Integer, Map<String, Object>> embedParamses = new HashMap<Integer, Map<String, Object>>();
        HashMap<Integer, StringBuilder> dslfBuilders = new HashMap<Integer, StringBuilder>();
        for (int i = 0; i < len; ++i) {
            Object value;
            String paramName;
            ParseConclusion parseConclusion;
            char c = dsl.charAt(i);
            if (isString) {
                if (c == '\\') {
                    ++backslashes;
                } else {
                    if (DSLUtils.isStringEnd(a, b, c, backslashes)) {
                        isString = false;
                    }
                    backslashes = 0;
                }
                if (deep > 0) {
                    ((StringBuilder)dslfBuilders.get(deep)).append(c);
                } else {
                    scriptBuilder.append(c);
                }
            } else if (isSinglelineComment) {
                if (isDynamic && DSLUtils.isDynamicEnd(c) && notParamAccessor) {
                    isSinglelineComment = false;
                    parseConclusion = DSLUtils.parseDSLFragment(context, params, paramGetter, scriptBuilder, dslfBuilders, attributeses, containsInValidParams, usedParams, validParamses, embedParamses, deep);
                    if (parseConclusion.finished) break;
                    deep = parseConclusion.deep;
                    if (deep < 1) {
                        isDynamic = false;
                        DSLUtils.deleteRedundantBlank(scriptBuilder);
                    } else {
                        DSLUtils.deleteRedundantBlank((StringBuilder)dslfBuilders.get(deep));
                    }
                } else {
                    if (c == '\n') {
                        isSinglelineComment = false;
                    }
                    if (deep > 0) {
                        ((StringBuilder)dslfBuilders.get(deep)).append(c);
                    } else {
                        scriptBuilder.append(c);
                    }
                }
            } else if (isMiltilineComment) {
                if (DSLUtils.isMiltilineCommentEnd(b, c)) {
                    isMiltilineComment = false;
                }
                if (deep > 0) {
                    ((StringBuilder)dslfBuilders.get(deep)).append(c);
                } else {
                    scriptBuilder.append(c);
                }
            } else if (c == '\'' && notParamAccessor) {
                if (deep > 0) {
                    ((StringBuilder)dslfBuilders.get(deep)).append(c);
                } else {
                    scriptBuilder.append(c);
                }
            } else if (DSLUtils.isSinglelineCommentBegin(b, c)) {
                isSinglelineComment = true;
                if (deep > 0) {
                    ((StringBuilder)dslfBuilders.get(deep)).append(c);
                } else {
                    scriptBuilder.append(c);
                }
            } else if (DSLUtils.isMiltilineCommentBegin(b, c)) {
                isMiltilineComment = true;
                if (deep > 0) {
                    ((StringBuilder)dslfBuilders.get(deep)).append(c);
                } else {
                    scriptBuilder.append(c);
                }
            } else if (isDynamic) {
                StringBuilder dslfBuilder;
                if (DSLUtils.isDynamicEnd(c) && notParamAccessor) {
                    if (isParam) {
                        isParam = false;
                        paramName = paramNameBuilder.toString();
                        value = paramGetter.getValue(params, paramName);
                        if (value != null) {
                            ((Map)validParamses.get(deep)).put(paramName, value);
                            paramNameBuilder.setLength(0);
                        } else if (deep > 0) {
                            containsInValidParams.add(deep);
                        }
                    } else if (isEmbed) {
                        isEmbed = false;
                        paramName = paramNameBuilder.toString();
                        value = paramGetter.getValue(params, paramName);
                        if (value != null) {
                            ((Map)embedParamses.get(deep)).put(paramName, value);
                            paramNameBuilder.setLength(0);
                        } else if (deep > 0) {
                            containsInValidParams.add(deep);
                        }
                    }
                    parseConclusion = DSLUtils.parseDSLFragment(context, params, paramGetter, scriptBuilder, dslfBuilders, attributeses, containsInValidParams, usedParams, validParamses, embedParamses, deep);
                    if (parseConclusion.finished) break;
                    deep = parseConclusion.deep;
                    if (deep < 1) {
                        isDynamic = false;
                        DSLUtils.deleteRedundantBlank(scriptBuilder);
                    } else {
                        DSLUtils.deleteRedundantBlank((StringBuilder)dslfBuilders.get(deep));
                    }
                } else if (isParam) {
                    if (c == '[') {
                        notParamAccessor = false;
                    } else if (c == ']') {
                        notParamAccessor = true;
                    }
                    if (DSLUtils.isParamChar(c)) {
                        paramNameBuilder.append(c);
                        dslfBuilder = (StringBuilder)dslfBuilders.get(deep);
                        if (dslfBuilder == null) {
                            dslfBuilder = new StringBuilder();
                            dslfBuilders.put(deep, dslfBuilder);
                        }
                        dslfBuilder.append(c);
                    } else {
                        isParam = false;
                        paramName = paramNameBuilder.toString();
                        value = paramGetter.getValue(params, paramName);
                        if (value != null) {
                            ((Map)validParamses.get(deep)).put(paramName, value);
                        } else if (deep >= 0) {
                            containsInValidParams.add(deep);
                        }
                        paramNameBuilder.setLength(0);
                        if (DSLUtils.isDynamicBegin(b, c)) {
                            dslfBuilder = (StringBuilder)dslfBuilders.get(deep);
                            dslfBuilder.deleteCharAt(dslfBuilder.length() - 1);
                            deep = DSLUtils.prepareForNext(deep, dslfBuilders, containsInValidParams, validParamses, embedParamses);
                        } else {
                            dslfBuilder = (StringBuilder)dslfBuilders.get(deep);
                            if (dslfBuilder == null) {
                                dslfBuilder = new StringBuilder();
                                dslfBuilders.put(deep, dslfBuilder);
                            }
                            dslfBuilder.append(c);
                        }
                    }
                } else if (isEmbed) {
                    if (c == '[') {
                        notParamAccessor = false;
                    } else if (c == ']') {
                        notParamAccessor = true;
                    }
                    if (DSLUtils.isParamChar(c)) {
                        paramNameBuilder.append(c);
                        dslfBuilder = (StringBuilder)dslfBuilders.get(deep);
                        if (dslfBuilder == null) {
                            dslfBuilder = new StringBuilder();
                            dslfBuilders.put(deep, dslfBuilder);
                        }
                        dslfBuilder.append(c);
                    } else {
                        isEmbed = false;
                        paramName = paramNameBuilder.toString();
                        value = paramGetter.getValue(params, paramName);
                        if (value != null) {
                            ((Map)embedParamses.get(deep)).put(paramName, value);
                        } else if (deep >= 0) {
                            containsInValidParams.add(deep);
                        }
                        paramNameBuilder.setLength(0);
                        if (DSLUtils.isDynamicBegin(b, c)) {
                            dslfBuilder = (StringBuilder)dslfBuilders.get(deep);
                            dslfBuilder.deleteCharAt(dslfBuilder.length() - 1);
                            deep = DSLUtils.prepareForNext(deep, dslfBuilders, containsInValidParams, validParamses, embedParamses);
                        } else {
                            dslfBuilder = (StringBuilder)dslfBuilders.get(deep);
                            if (dslfBuilder == null) {
                                dslfBuilder = new StringBuilder();
                                dslfBuilders.put(deep, dslfBuilder);
                            }
                            dslfBuilder.append(c);
                        }
                    }
                } else if (DSLUtils.isDynamicBegin(b, c)) {
                    dslfBuilder = (StringBuilder)dslfBuilders.get(deep);
                    dslfBuilder.deleteCharAt(dslfBuilder.length() - 1);
                    deep = DSLUtils.prepareForNext(deep, dslfBuilders, containsInValidParams, validParamses, embedParamses);
                } else {
                    if (DSLUtils.isParamBegin(a, b, c)) {
                        isParam = true;
                        paramNameBuilder.setLength(0);
                        paramNameBuilder.append(c);
                    } else if (DSLUtils.isEmbedBegin(a, b, c)) {
                        isEmbed = true;
                        paramNameBuilder.setLength(0);
                        paramNameBuilder.append(c);
                    }
                    dslfBuilder = (StringBuilder)dslfBuilders.get(deep);
                    if (dslfBuilder == null) {
                        dslfBuilder = new StringBuilder();
                        dslfBuilders.put(deep, dslfBuilder);
                    }
                    dslfBuilder.append(c);
                }
            } else if (DSLUtils.isDynamicBegin(b, c)) {
                isDynamic = true;
                scriptBuilder.deleteCharAt(scriptBuilder.length() - 1);
                deep = DSLUtils.prepareForNext(deep, dslfBuilders, containsInValidParams, validParamses, embedParamses);
            } else {
                if (isParam) {
                    if (DSLUtils.isParamChar(c)) {
                        paramNameBuilder.append(c);
                        if (i == len - 1) {
                            paramName = paramNameBuilder.toString();
                            usedParams.put(paramName, paramGetter.getValue(params, paramName));
                        }
                    } else {
                        isParam = false;
                        paramName = paramNameBuilder.toString();
                        usedParams.put(paramName, paramGetter.getValue(params, paramName));
                        if (i < len - 1) {
                            paramNameBuilder.setLength(0);
                        }
                    }
                } else if (isEmbed) {
                    if (DSLUtils.isParamChar(c)) {
                        paramNameBuilder.append(c);
                        if (i == len - 1) {
                            scriptBuilder.setLength(scriptBuilder.length() - paramNameBuilder.length());
                            value = paramGetter.getValue(params, paramNameBuilder.toString());
                            scriptBuilder.append(value == null ? "null" : value.toString());
                            break;
                        }
                    } else {
                        isEmbed = false;
                        scriptBuilder.setLength(scriptBuilder.length() - paramNameBuilder.length() - 1);
                        value = paramGetter.getValue(params, paramNameBuilder.toString());
                        scriptBuilder.append(value == null ? "null" : value.toString());
                        if (i < len - 1) {
                            paramNameBuilder.setLength(0);
                        }
                    }
                } else if (DSLUtils.isParamBegin(a, b, c)) {
                    isParam = true;
                    paramNameBuilder.setLength(0);
                    paramNameBuilder.append(c);
                } else if (DSLUtils.isEmbedBegin(a, b, c)) {
                    isEmbed = true;
                    paramNameBuilder.setLength(0);
                    paramNameBuilder.append(c);
                }
                scriptBuilder.append(c);
            }
            a = b;
            b = c;
        }
        return new NamedScript(scriptBuilder.toString(), usedParams);
    }

    public static <T> Script<T> toScript(NamedScript namedScript, ParamsParser<T> parser) {
        return DSLUtils.toScript(namedScript.getScript(), namedScript.getParams(), parser);
    }

    public static <T> Script<T> toScript(String namedscript, Map<String, ?> params, ParamsParser<T> parser) {
        if (params == null) {
            params = new HashMap();
        }
        T targetParams = parser.newParams();
        if (StringUtils.isBlank(namedscript)) {
            return new Script<T>(namedscript, targetParams);
        }
        int len = namedscript.length();
        int backslashes = 0;
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        boolean isSinglelineComment = false;
        boolean isMiltilineComment = false;
        boolean isParam = false;
        boolean notParamAccessor = true;
        StringBuilder scriptBuilder = new StringBuilder();
        StringBuilder commentBuilder = new StringBuilder();
        StringBuilder paramName = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = namedscript.charAt(i);
            if (isString) {
                if (c == '\\') {
                    ++backslashes;
                } else {
                    if (DSLUtils.isStringEnd(a, b, c, backslashes)) {
                        isString = false;
                    }
                    backslashes = 0;
                }
                scriptBuilder.append(c);
            } else if (isSinglelineComment) {
                commentBuilder.append(c);
                if (c == '\n') {
                    isSinglelineComment = false;
                    scriptBuilder.append((CharSequence)commentBuilder);
                    commentBuilder.setLength(0);
                }
            } else if (isMiltilineComment) {
                commentBuilder.append(c);
                if (DSLUtils.isMiltilineCommentEnd(b, c)) {
                    isMiltilineComment = false;
                    scriptBuilder.append((CharSequence)commentBuilder);
                    commentBuilder.setLength(0);
                }
            } else if (c == '\'' && notParamAccessor) {
                isString = true;
                scriptBuilder.append(c);
            } else if (DSLUtils.isSinglelineCommentBegin(b, c)) {
                isSinglelineComment = true;
                commentBuilder.append(c);
            } else if (DSLUtils.isMiltilineCommentBegin(b, c)) {
                isMiltilineComment = true;
                commentBuilder.append(c);
            } else if (isParam) {
                if (c == '[') {
                    notParamAccessor = false;
                } else if (c == ']') {
                    notParamAccessor = true;
                }
                if (DSLUtils.isParamChar(c)) {
                    paramName.append(c);
                } else {
                    isParam = false;
                    parser.parse(scriptBuilder, params, paramName.toString(), targetParams);
                    scriptBuilder.append(c);
                }
            } else if (DSLUtils.isParamBegin(a, b, c)) {
                isParam = true;
                paramName.setLength(0);
                paramName.append(c);
                scriptBuilder.deleteCharAt(scriptBuilder.length() - 1);
            } else {
                scriptBuilder.append(c);
            }
            a = b;
            b = c;
        }
        if (isParam) {
            parser.parse(scriptBuilder, params, paramName.toString(), targetParams);
        }
        if (commentBuilder.length() > 0) {
            scriptBuilder.append((CharSequence)commentBuilder);
        }
        return new Script<T>(scriptBuilder.toString(), targetParams);
    }

    public static Map<String, Object> getUsedParams(ParamGetter paramGetter, CharSequence namedscript, Object params) {
        char a;
        HashMap<String, Object> usedParams = new HashMap<String, Object>();
        int len = namedscript.length();
        int last = len - 1;
        int backslashes = 0;
        char b = a = ' ';
        boolean isString = false;
        boolean isSinglelineComment = false;
        boolean isMiltilineComment = false;
        boolean isParam = false;
        boolean isEmbed = false;
        boolean notParamAccessor = true;
        StringBuilder paramNameBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            String paramName;
            char c = namedscript.charAt(i);
            if (isString) {
                if (c == '\\') {
                    ++backslashes;
                } else {
                    if (DSLUtils.isStringEnd(a, b, c, backslashes)) {
                        isString = false;
                    }
                    backslashes = 0;
                }
            } else if (isSinglelineComment) {
                if (c == '\n') {
                    isSinglelineComment = false;
                }
            } else if (isMiltilineComment) {
                if (DSLUtils.isMiltilineCommentEnd(b, c)) {
                    isMiltilineComment = false;
                }
            } else if (c == '\'' && notParamAccessor) {
                isString = true;
            } else if (DSLUtils.isSinglelineCommentBegin(b, c)) {
                isSinglelineComment = true;
            } else if (DSLUtils.isMiltilineCommentBegin(b, c)) {
                isMiltilineComment = true;
            } else if (isParam) {
                if (c == '[') {
                    notParamAccessor = false;
                } else if (c == ']') {
                    notParamAccessor = true;
                }
                if (DSLUtils.isParamChar(c)) {
                    paramNameBuilder.append(c);
                    if (i == last) {
                        paramName = paramNameBuilder.toString();
                        usedParams.put(paramName, paramGetter.getValue(params, paramName));
                        break;
                    }
                } else {
                    isParam = false;
                    paramName = paramNameBuilder.toString();
                    usedParams.put(paramName, paramGetter.getValue(params, paramName));
                    if (i < last) {
                        paramNameBuilder.setLength(0);
                    }
                }
            } else if (isEmbed) {
                if (c == '[') {
                    notParamAccessor = false;
                } else if (c == ']') {
                    notParamAccessor = true;
                }
                if (DSLUtils.isParamChar(c)) {
                    paramNameBuilder.append(c);
                    if (i == last) {
                        paramName = paramNameBuilder.toString();
                        usedParams.put(paramName, paramGetter.getValue(params, paramName));
                        break;
                    }
                } else {
                    isEmbed = false;
                    paramName = paramNameBuilder.toString();
                    usedParams.put(paramName, paramGetter.getValue(params, paramName));
                    if (i < last) {
                        paramNameBuilder.setLength(0);
                    }
                }
            } else if (DSLUtils.isParamBegin(a, b, c)) {
                isParam = true;
                paramNameBuilder.setLength(0);
                paramNameBuilder.append(c);
            } else if (DSLUtils.isEmbedBegin(a, b, c)) {
                isEmbed = true;
                paramNameBuilder.setLength(0);
                paramNameBuilder.append(c);
            }
            a = b;
            b = c;
        }
        return usedParams;
    }

    public static boolean isParamBegin(char a, char b, char c) {
        return b == PARAM_PREFIX && a != PARAM_PREFIX && DSLUtils.is26LettersIgnoreCase(c);
    }

    public static boolean isEmbedBegin(char a, char b, char c) {
        return b == EMBED_PREFIX && a != EMBED_PREFIX && DSLUtils.is26LettersIgnoreCase(c);
    }

    public static boolean isParamChar(char c) {
        return DSLUtils.is26LettersIgnoreCase(c) || c >= '0' && c <= '9' || PARAM_CHARS.contains(Character.valueOf(c));
    }

    public static boolean isStringEnd(char a, char b, char c, int backslashes) {
        if (c == '\'') {
            if (b == '\\') {
                return backslashes % 2 == 0;
            }
            return true;
        }
        return false;
    }

    public static boolean isSinglelineCommentBegin(char b, char c) {
        for (int i = 0; i < SINGLELINE_COMMENT_PREFIXES.length; ++i) {
            char[] singlelineCommentPrefix = SINGLELINE_COMMENT_PREFIXES[i];
            if (!(singlelineCommentPrefix.length > 1 ? b == singlelineCommentPrefix[0] && c == singlelineCommentPrefix[1] : c == singlelineCommentPrefix[0])) continue;
            return true;
        }
        return false;
    }

    public static boolean isMiltilineCommentBegin(char b, char c) {
        for (int i = 0; i < MILTILINE_COMMENT_PREFIXES.length; ++i) {
            char[] multilineCommentPrefix = MILTILINE_COMMENT_PREFIXES[i];
            if (!(multilineCommentPrefix.length > 1 ? b == multilineCommentPrefix[0] && c == multilineCommentPrefix[1] : c == multilineCommentPrefix[0])) continue;
            return true;
        }
        return false;
    }

    public static boolean isMiltilineCommentEnd(char b, char c) {
        for (int i = 0; i < MILTILINE_COMMENT_SUFFIXES.length; ++i) {
            char[] multilineCommentSuffix = MILTILINE_COMMENT_SUFFIXES[i];
            if (!(multilineCommentSuffix.length > 1 ? b == multilineCommentSuffix[0] && c == multilineCommentSuffix[1] : c == multilineCommentSuffix[0])) continue;
            return true;
        }
        return false;
    }

    public static void convert(List<ParamsConverter<?>> paramsConverters, Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String paramName = entry.getKey();
            Object value = DSLUtils.convert(paramsConverters, paramName, entry.getValue());
            params.put(paramName, DSLUtils.convert(paramsConverters, paramName, value));
        }
    }

    public static void filter(List<ParamsFilter> paramsFilters, Map<String, Object> params) {
        HashSet<String> filteredParams = new HashSet<String>();
        Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
        while (it.hasNext()) {
            Object value;
            Map.Entry<String, Object> entry = it.next();
            String paramName = entry.getKey();
            if (!DSLUtils.filtered(paramsFilters, filteredParams, paramName, value = entry.getValue())) continue;
            it.remove();
            filteredParams.add(paramName);
            break;
        }
    }

    private static int prepareForNext(int currentDeep, Map<Integer, StringBuilder> dslfBuilders, Set<Integer> containsInValidParams, Map<Integer, Map<String, Object>> validParamses, Map<Integer, Map<String, Object>> embedParamses) {
        Map<String, Object> params;
        int newDeep = currentDeep + 1;
        if (!containsInValidParams.contains(newDeep) && MapUtils.isNotEmpty(params = validParamses.get(newDeep))) {
            validParamses.get(currentDeep).putAll(params);
        }
        dslfBuilders.put(newDeep, new StringBuilder());
        validParamses.put(newDeep, new HashMap());
        embedParamses.put(newDeep, new HashMap());
        return newDeep;
    }

    private static String deleteStartBlankLines(String dsl) {
        char c;
        int lastLineTailIndex = -1;
        int len = dsl.length();
        for (int i = 0; i < len && Character.isWhitespace(c = dsl.charAt(i)); ++i) {
            if (!LINE_TAIL.contains(Character.valueOf(c))) continue;
            lastLineTailIndex = i;
        }
        if (lastLineTailIndex >= 0) {
            return dsl.substring(lastLineTailIndex + 1);
        }
        return dsl;
    }

    private static ParseConclusion parseDSLFragment(DSLContext context, Object params, ParamGetter paramGetter, StringBuilder scriptBuilder, Map<Integer, StringBuilder> dslfBuilders, Map<Integer, Map<String, Object>> attributeses, Set<Integer> containsInValidParams, Map<String, Object> usedParams, Map<Integer, Map<String, Object>> validParamses, Map<Integer, Map<String, Object>> embedParamses, int deep) {
        ParseConclusion conclusion = new ParseConclusion();
        if (containsInValidParams.contains(deep)) {
            if (deep > 0) {
                if (DSLUtils.parseDSLFragment(context, params, paramGetter, scriptBuilder, dslfBuilders, attributeses, containsInValidParams, usedParams, validParamses, embedParamses, deep, true)) {
                    DSLUtils.deleteRedundantBlank(scriptBuilder);
                    conclusion.finished = true;
                    return conclusion;
                }
                conclusion.deep = deep - 1;
            }
        } else {
            if (DSLUtils.parseDSLFragment(context, params, paramGetter, scriptBuilder, dslfBuilders, attributeses, containsInValidParams, usedParams, validParamses, embedParamses, deep, false)) {
                DSLUtils.deleteRedundantBlank(scriptBuilder);
                conclusion.finished = true;
                return conclusion;
            }
            conclusion.deep = deep - 1;
        }
        return conclusion;
    }

    private static final boolean parseDSLFragment(DSLContext context, Object params, ParamGetter paramGetter, StringBuilder scriptBuilder, Map<Integer, StringBuilder> dslfBuilders, Map<Integer, Map<String, Object>> attributeses, Set<Integer> containsInValidParams, Map<String, Object> usedParams, Map<Integer, Map<String, Object>> validParamses, Map<Integer, Map<String, Object>> embedParamses, int deep, boolean emptyWhenNoMacro) {
        Map<String, Object> validParams = validParamses.get(deep);
        Map<String, Object> attributes = attributeses.get(deep);
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
            attributeses.put(deep, attributes);
        }
        MacroUtils.Dslf dslf = MacroUtils.execute(context, attributes, dslfBuilders.get(deep), validParams, emptyWhenNoMacro);
        boolean dslfAsScript = dslf.isDslfAsScript();
        if (containsInValidParams.contains(deep)) {
            validParamses.remove(deep);
        } else {
            Map<String, Object> prevValidParams = validParamses.get(deep + 1);
            if (MapUtils.isNotEmpty(prevValidParams)) {
                validParams.putAll(prevValidParams);
            }
        }
        if (deep == 1) {
            if (!containsInValidParams.contains(deep)) {
                usedParams.putAll(validParams);
            }
            containsInValidParams.clear();
            validParamses.clear();
            DSLUtils.replaceEmbedParams(params, scriptBuilder, dslf, embedParamses, deep);
        } else if (dslfAsScript) {
            DSLUtils.replaceEmbedParams(params, scriptBuilder, dslf, embedParamses, deep);
        } else {
            dslfBuilders.get(deep - 1).append((CharSequence)dslf.getValue());
        }
        dslfBuilders.remove(deep);
        return dslfAsScript;
    }

    private static void replaceEmbedParams(Object params, StringBuilder scriptBuilder, MacroUtils.Dslf dslf, Map<Integer, Map<String, Object>> embedParamses, int deep) {
        if (dslf.isDslfAsScript()) {
            scriptBuilder.setLength(0);
        }
        if (embedParamses.isEmpty()) {
            scriptBuilder.append((CharSequence)dslf.getValue());
        } else {
            String namedScript = dslf.getValue().toString();
            for (Map.Entry<String, Object> entry : embedParamses.get(deep).entrySet()) {
                Object value = entry.getValue();
                namedScript = namedScript.replaceAll(EMBED_PREFIX + entry.getKey(), value == null ? "null" : value.toString());
            }
            scriptBuilder.append(namedScript);
        }
    }

    private static boolean isDynamicBegin(char b, char c) {
        return b == DYNAMIC_PREFIX[0] && c == DYNAMIC_PREFIX[1];
    }

    private static boolean isDynamicEnd(char c) {
        return c == DYNAMIC_SUFFIX;
    }

    private static void deleteRedundantBlank(StringBuilder sb) {
        int len = sb.length();
        for (int i = len - 1; i >= 0; --i) {
            char c = sb.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.setLength(i + 1);
            return;
        }
        sb.setLength(0);
    }

    private static boolean is26LettersIgnoreCase(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static Object convert(List<ParamsConverter<?>> paramsConverters, String paramName, Object value) {
        int size = paramsConverters.size();
        for (int i = 0; i < size; ++i) {
            ParamsConverter<?> paramsConverter = paramsConverters.get(i);
            if (!paramsConverter.determine(paramName)) continue;
            value = paramsConverter.convert(value);
        }
        return value;
    }

    private static Object convert(List<ParamsConverter<?>> paramsConverters, Map<String, Object> convertedParams, String paramName, Object value) {
        value = DSLUtils.convert(paramsConverters, paramName, value);
        convertedParams.put(paramName, value);
        return value;
    }

    private static boolean filtered(List<ParamsFilter> paramsFilters, Set<String> filteredParams, String paramName, Object value) {
        int size = paramsFilters.size();
        for (int i = 0; i < size; ++i) {
            ParamsFilter paramsFilter = paramsFilters.get(i);
            if (!paramsFilter.determine(paramName, value)) continue;
            filteredParams.add(paramName);
            return true;
        }
        return false;
    }

    private static ParamGetter getParamGetter(DSLContext context) {
        List<ParamsConverter<?>> paramsConverters = context.getParamsConverters();
        List<ParamsFilter> paramsFilters = context.getParamsFilters();
        if (CollectionUtils.isEmpty(paramsConverters)) {
            if (CollectionUtils.isEmpty(paramsFilters)) {
                return SimpleParamGetter.getInstance();
            }
            return new FilterAbleParamGetter(paramsFilters);
        }
        if (CollectionUtils.isEmpty(paramsFilters)) {
            return new ConvertAbleParamGetter(paramsConverters);
        }
        return new FullFeaturesParamGetter(paramsConverters, paramsFilters);
    }

    static {
        defaultDSLContext = new DefaultDSLContext();
        LINE_TAIL = SetUtils.newHashSet(Character.valueOf('\r'), Character.valueOf('\n'));
        PARAM_CHARS = SetUtils.newHashSet(Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('_'), Character.valueOf('\''), Character.valueOf('\"'));
        DYNAMIC_PREFIX = ConfigUtils.getProperty("dynamic.prefix", "#[").toCharArray();
        DYNAMIC_SUFFIX = ConfigUtils.getProperty("dynamic.suffix", "]").charAt(0);
        PARAM_PREFIX = ConfigUtils.getProperty("param.prefix", ":").charAt(0);
        EMBED_PREFIX = ConfigUtils.getProperty("embed.prefix", "#").charAt(0);
        String[] singlelineCommentPrefixes = ConfigUtils.getProperty("comment.singleline", "--,//").split(",");
        String[] miltilineComments = ConfigUtils.getProperty("comment.multiline", "/*,*/").split(";");
        SINGLELINE_COMMENT_PREFIXES = new char[singlelineCommentPrefixes.length][];
        MILTILINE_COMMENT_PREFIXES = new char[miltilineComments.length][];
        MILTILINE_COMMENT_SUFFIXES = new char[miltilineComments.length][];
        for (int i = 0; i < singlelineCommentPrefixes.length; ++i) {
            DSLUtils.SINGLELINE_COMMENT_PREFIXES[i] = singlelineCommentPrefixes[i].toCharArray();
        }
        for (int i = 0; i < miltilineComments.length; ++i) {
            String[] miltilineComment = miltilineComments[i].split(",");
            DSLUtils.MILTILINE_COMMENT_PREFIXES[i] = miltilineComment[0].toCharArray();
            DSLUtils.MILTILINE_COMMENT_SUFFIXES[i] = miltilineComment[1].toCharArray();
        }
    }

    private static class ParseConclusion {
        private boolean finished;
        private int deep;

        private ParseConclusion() {
        }
    }

    protected static interface ParamGetter {
        public Object getValue(Object var1, String var2);
    }

    public static class FullFeaturesParamGetter
    implements ParamGetter {
        private final Map<String, Object> convertedParams = new HashMap<String, Object>();
        private final Set<String> filteredParams = new HashSet<String>();
        private final List<ParamsConverter<?>> converters;
        private final List<ParamsFilter> filters;

        private FullFeaturesParamGetter(List<ParamsConverter<?>> converters, List<ParamsFilter> filters) {
            this.converters = converters;
            this.filters = filters;
        }

        public static FullFeaturesParamGetter newInstance(List<ParamsConverter<?>> converters, List<ParamsFilter> filters) {
            return new FullFeaturesParamGetter(converters, filters);
        }

        @Override
        public Object getValue(Object params, String paramName) {
            if (this.convertedParams.containsKey(paramName)) {
                return this.convertedParams.get(paramName);
            }
            if (this.filteredParams.contains(paramName)) {
                return null;
            }
            Object value = DSLUtils.convert(this.converters, this.convertedParams, paramName, ObjectUtils.getValueIgnoreException(params, paramName));
            return DSLUtils.filtered(this.filters, this.filteredParams, paramName, value) ? null : value;
        }
    }

    public static class FilterAbleParamGetter
    implements ParamGetter {
        private final Set<String> filteredParams = new HashSet<String>();
        private final List<ParamsFilter> filters;

        private FilterAbleParamGetter(List<ParamsFilter> filters) {
            this.filters = filters;
        }

        public static FilterAbleParamGetter newInstance(List<ParamsFilter> filters) {
            return new FilterAbleParamGetter(filters);
        }

        @Override
        public Object getValue(Object params, String paramName) {
            Object value = ObjectUtils.getValueIgnoreException(params, paramName);
            if (this.filteredParams.contains(paramName) || DSLUtils.filtered(this.filters, this.filteredParams, paramName, value)) {
                return null;
            }
            return value;
        }
    }

    public static class ConvertAbleParamGetter
    implements ParamGetter {
        private final Map<String, Object> convertedParams = new HashMap<String, Object>();
        private final List<ParamsConverter<?>> converters;

        private ConvertAbleParamGetter(List<ParamsConverter<?>> converters) {
            this.converters = converters;
        }

        public static ConvertAbleParamGetter newInstance(List<ParamsConverter<?>> converters) {
            return new ConvertAbleParamGetter(converters);
        }

        @Override
        public Object getValue(Object params, String paramName) {
            if (this.convertedParams.containsKey(paramName)) {
                return this.convertedParams.get(paramName);
            }
            return DSLUtils.convert(this.converters, this.convertedParams, paramName, ObjectUtils.getValueIgnoreException(params, paramName));
        }
    }

    public static class SimpleParamGetter
    implements ParamGetter {
        private static final SimpleParamGetter INSTANCE = new SimpleParamGetter();

        private SimpleParamGetter() {
        }

        public static SimpleParamGetter getInstance() {
            return INSTANCE;
        }

        @Override
        public Object getValue(Object params, String paramName) {
            return ObjectUtils.getValueIgnoreException(params, paramName);
        }
    }
}

