/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsl.utils;

import cn.tenmg.dsl.exception.DateFormatException;
import cn.tenmg.dsl.exception.DateParseException;
import cn.tenmg.dsl.utils.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DateUtils {
    private static final ConcurrentHashMap<String, DateFormat> FORMATTERS = new ConcurrentHashMap();

    public static String format(Object obj, String pattern) {
        return DateUtils.formatter(pattern).format(obj);
    }

    public static Date parse(Object obj, String pattern) {
        String str;
        DateFormat formatter = DateUtils.formatter(pattern);
        if (obj instanceof String) {
            try {
                return formatter.parse((String)obj);
            }
            catch (Exception e) {
                throw new DateParseException(StringUtils.concat("An exception occurred when using the pattern: ", pattern, " to parse the String: ", obj, " to Date"), e);
            }
        }
        try {
            str = formatter.format(obj);
        }
        catch (Exception e) {
            throw new DateFormatException(StringUtils.concat("An exception occurred when using the pattern: ", pattern, " to format the Object: ", obj, " to String"), e);
        }
        try {
            return formatter.parse(str);
        }
        catch (Exception e) {
            throw new DateParseException(StringUtils.concat("An exception occurred when using the pattern: ", pattern, " to parse the String: ", str, " to Date"), e);
        }
    }

    public static Date addDays(Date date, int days) {
        return DateUtils.add(date, 5, days);
    }

    public static Date addMonths(Date date, int months) {
        return DateUtils.add(date, 2, months);
    }

    public static Date addYears(Date date, int years) {
        return DateUtils.add(date, 1, years);
    }

    public static Date trunc(Date date, String fmt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        if ("SECOND".equalsIgnoreCase(fmt)) {
            return cal.getTime();
        }
        cal.set(13, 0);
        if ("MINUTE".equalsIgnoreCase(fmt)) {
            return cal.getTime();
        }
        cal.set(12, 0);
        if ("HOUR".equalsIgnoreCase(fmt)) {
            return cal.getTime();
        }
        cal.set(11, 0);
        if ("DAY".equalsIgnoreCase(fmt)) {
            return cal.getTime();
        }
        cal.set(5, 1);
        if ("MONTH".equalsIgnoreCase(fmt)) {
            return cal.getTime();
        }
        cal.set(2, 0);
        if ("YEAR".equalsIgnoreCase(fmt)) {
            return cal.getTime();
        }
        return cal.getTime();
    }

    public static Date add(Date date, int field, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, amount);
        return cal.getTime();
    }

    private static DateFormat formatter(String pattern) {
        DateFormat formatter = FORMATTERS.get(pattern);
        if (formatter == null) {
            formatter = new SimpleDateFormat(pattern);
            FORMATTERS.put(pattern, formatter);
        }
        return formatter;
    }
}

