/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsql.utils;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.dsql.ParamsFilter;
import cn.tenmg.dsql.config.model.ParamsHandler;
import cn.tenmg.dsql.utils.DateUtils;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class ParamsFilterUtils {
    private static final String ZERO = "0";
    private static final String DATE_REGEX = "(-| |/|:)";
    private static final String DATE_PATTERN = "yyyyMMddHHmmss";
    private static final int DATE_PATTERN_LENGTH = "yyyyMMddHHmmss".length();
    private static final String TIME_REGEX = ":";
    private static final String TIME_PATTERN = "HHmmss";
    private static final int TIME_PATTERN_LENGTH = "HHmmss".length();
    private static final String PARAMS_FILTER = "ParamsFilter";
    private static final Map<String, ParamsFilter<ParamsHandler>> paramsFilters = new HashMap<String, ParamsFilter<ParamsHandler>>();

    public static ParamsFilter<ParamsHandler> getParamsFilter(Class<? extends ParamsHandler> configType) {
        return paramsFilters.get(configType.getSimpleName().concat(PARAMS_FILTER));
    }

    public static FilterTuple convert(Object paramValue, String value) {
        FilterTuple filterTuple = new FilterTuple();
        if (paramValue instanceof String) {
            filterTuple.setParamValue((String)paramValue);
        } else if (paramValue instanceof Time) {
            if (StringUtils.isNumber((String)(value = value.replaceAll(TIME_REGEX, "")))) {
                StringBuilder sb = new StringBuilder(value);
                for (int j = value.length(); j < TIME_PATTERN_LENGTH; ++j) {
                    sb.append(ZERO);
                }
                value = sb.toString();
                filterTuple.setParamValue(DateUtils.format(paramValue, TIME_PATTERN));
            }
        } else if (paramValue instanceof Date || paramValue instanceof Calendar) {
            if (StringUtils.isNumber((String)(value = value.replaceAll(DATE_REGEX, "")))) {
                StringBuilder sb = new StringBuilder(value);
                for (int j = value.length(); j < DATE_PATTERN_LENGTH; ++j) {
                    sb.append(ZERO);
                }
                value = sb.toString();
                filterTuple.setParamValue(DateUtils.format(paramValue, DATE_PATTERN));
            }
        } else {
            filterTuple.setParamValue(paramValue.toString());
        }
        filterTuple.setValue(value);
        return filterTuple;
    }

    public static <T> void blankFilter(Map<String, T> params) {
        Iterator<Map.Entry<String, T>> it = params.entrySet().iterator();
        while (it.hasNext()) {
            T paramValue = it.next().getValue();
            if (paramValue != null && !StringUtils.isBlank((String)paramValue.toString())) continue;
            it.remove();
        }
    }

    public static <T> void blankFilter(String paramName, Map<String, T> params) {
        T paramValue = params.get(paramName);
        if (paramValue == null || StringUtils.isBlank((String)paramValue.toString())) {
            params.remove(paramName);
        }
    }

    static {
        ServiceLoader<ParamsFilter> loader = ServiceLoader.load(ParamsFilter.class);
        for (ParamsFilter paramsFilter : loader) {
            paramsFilters.put(paramsFilter.getClass().getSimpleName(), paramsFilter);
        }
    }

    public static class FilterTuple {
        private String paramValue;
        private String value;

        public String getParamValue() {
            return this.paramValue;
        }

        public void setParamValue(String paramValue) {
            this.paramValue = paramValue;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

