/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsql.filter;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.dsql.ParamsFilter;
import cn.tenmg.dsql.config.model.filter.CompareableFilter;
import cn.tenmg.dsql.utils.ParamsFilterUtils;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractParamsFilter
implements ParamsFilter<CompareableFilter> {
    abstract boolean compare(String var1, String var2);

    @Override
    public void doFilter(Map<String, ?> params, CompareableFilter config) {
        String paramsConfig = config.getParams();
        String value = config.getValue();
        if (StringUtils.isNotBlank((String)value) && StringUtils.isNotBlank((String)paramsConfig)) {
            String[] paramNames = paramsConfig.split(",");
            for (int j = 0; j < paramNames.length; ++j) {
                String paramName = paramNames[j].trim();
                if ("*".equals(paramName)) {
                    this.filterAll(params, value);
                    break;
                }
                if (!params.containsKey(paramName)) continue;
                this.filter(params, paramName, value);
            }
        }
    }

    <T> void filterAll(Map<String, T> params, String value) {
        Iterator<Map.Entry<String, T>> it = params.entrySet().iterator();
        while (it.hasNext()) {
            T paramValue = it.next().getValue();
            if (paramValue == null || !this.isFilterAble(paramValue, value)) continue;
            it.remove();
        }
    }

    <T> void filter(Map<String, T> params, String paramName, String value) {
        T paramValue = params.get(paramName);
        if (paramValue != null && this.isFilterAble(paramValue, value)) {
            params.remove(paramName);
        }
    }

    boolean isFilterAble(Object paramValue, String value) {
        ParamsFilterUtils.FilterTuple tuple = ParamsFilterUtils.convert(paramValue, value);
        return this.compare(tuple.getParamValue(), tuple.getValue());
    }
}

