/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsql.factory;

import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.parser.JDBCParamsParser;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsql.DSQLFactory;
import cn.tenmg.dsql.NamedSQL;
import cn.tenmg.dsql.ParamsConverter;
import cn.tenmg.dsql.ParamsFilter;
import cn.tenmg.dsql.config.model.Converter;
import cn.tenmg.dsql.config.model.Dsql;
import cn.tenmg.dsql.config.model.Filter;
import cn.tenmg.dsql.config.model.ParamsHandler;
import cn.tenmg.dsql.utils.CollectionUtils;
import cn.tenmg.dsql.utils.ParamsConverterUtils;
import cn.tenmg.dsql.utils.ParamsFilterUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDSQLFactory
implements DSQLFactory {
    private static final long serialVersionUID = -169658678380590492L;

    abstract Map<String, Dsql> getDsqls();

    @Override
    public Dsql getDsql(String id) {
        return this.getDsqls().get(id);
    }

    @Override
    public String getScript(String id) {
        Dsql dsql = this.getDsql(id);
        if (dsql == null) {
            return null;
        }
        return dsql.getScript();
    }

    @Override
    public NamedSQL parse(String dsql, Object ... params) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (params != null) {
            for (int i = 0; i < params.length - 1; ++i) {
                paramsMap.put(params[i].toString(), params[++i]);
            }
        }
        return this.parse(dsql, paramsMap);
    }

    @Override
    public NamedSQL parse(String dsql, Map<String, ?> params) {
        NamedSQL namedSQL = null;
        Dsql obj = this.getDsql(dsql);
        namedSQL = obj == null ? new NamedSQL(DSLUtils.parse((String)dsql, (Object[])new Object[]{params})) : this.parse(obj, params);
        return namedSQL;
    }

    @Override
    public Script<List<Object>> toJDBC(NamedSQL namedSQL) {
        return this.toJDBC(namedSQL.getScript(), namedSQL.getParams());
    }

    @Override
    public Script<List<Object>> toJDBC(String namedscript, Map<String, ?> params) {
        return DSLUtils.toScript((String)namedscript, params, (ParamsParser)JDBCParamsParser.getInstance());
    }

    protected NamedSQL parse(Dsql dsql, Map<String, ?> params) {
        Filter filter = dsql.getFilter();
        if (!CollectionUtils.isEmpty(params)) {
            Converter converter;
            if (filter != null) {
                this.doFilter(params, filter);
            }
            if ((converter = dsql.getConverter()) != null) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.putAll(params);
                this.convert(parameters, converter);
                params = parameters;
            }
        }
        NamedSQL namedSQL = new NamedSQL(DSLUtils.parse((String)dsql.getScript(), (Object[])new Object[]{params}));
        namedSQL.setId(dsql.getId());
        return namedSQL;
    }

    private void doFilter(Map<String, ?> params, Filter filter) {
        List<ParamsHandler> paramsFilters = filter.getParamsFilters();
        if (!CollectionUtils.isEmpty(paramsFilters)) {
            int size = paramsFilters.size();
            for (int i = 0; i < size; ++i) {
                ParamsHandler config = paramsFilters.get(i);
                ParamsFilter<ParamsHandler> paramsFilter = ParamsFilterUtils.getParamsFilter(config.getClass());
                paramsFilter.doFilter(params, config);
            }
        }
    }

    private void convert(Map<String, Object> params, Converter converter) {
        List<ParamsHandler> paramsConverters = converter.getParamsConverters();
        if (!CollectionUtils.isEmpty(paramsConverters)) {
            int size = paramsConverters.size();
            for (int i = 0; i < size; ++i) {
                ParamsHandler config = paramsConverters.get(i);
                ParamsConverter<ParamsHandler> paramsConverter = ParamsConverterUtils.getParamsConverter(config.getClass());
                paramsConverter.convert(params, config);
            }
        }
    }
}

