/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsql.factory;

import cn.tenmg.dsl.utils.ClassUtils;
import cn.tenmg.dsql.config.loader.XMLConfigLoader;
import cn.tenmg.dsql.config.model.Dsql;
import cn.tenmg.dsql.exception.IllegalConfigException;
import cn.tenmg.dsql.factory.AbstractDSQLFactory;
import cn.tenmg.dsql.utils.CollectionUtils;
import cn.tenmg.dsql.utils.FileUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XMLFileDSQLFactory
extends AbstractDSQLFactory {
    private static final long serialVersionUID = 8125151681490092061L;
    private static final Logger log = LogManager.getLogger(XMLFileDSQLFactory.class);
    private final Map<String, Dsql> dsqls = new HashMap<String, Dsql>();
    private String basePackages;
    private String suffix = ".dsql.xml";

    public String getBasePackages() {
        return this.basePackages;
    }

    public void setBasePackages(String basePackages) {
        this.basePackages = basePackages;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public XMLFileDSQLFactory(String basePackages) {
        this.basePackages = basePackages;
        this.init();
    }

    public XMLFileDSQLFactory(String basePackages, String suffix) {
        this.basePackages = basePackages;
        this.suffix = suffix;
        this.init();
    }

    @Override
    Map<String, Dsql> getDsqls() {
        return this.dsqls;
    }

    private void init() {
        if (this.basePackages == null) {
            log.warn("The parameter basePackages is null");
        } else {
            String[] basePackages = this.basePackages.split(",");
            for (int i = 0; i < basePackages.length; ++i) {
                String basePackage = basePackages[i];
                try {
                    log.info("Scan package: ".concat(basePackage));
                    List<String> fileNames = FileUtils.scanPackage(basePackage, this.suffix);
                    if (!CollectionUtils.isEmpty(fileNames)) {
                        int size = fileNames.size();
                        for (int j = 0; j < size; ++j) {
                            String fileName = fileNames.get(j);
                            log.info("Start parsing " + fileName);
                            List<Dsql> dsqls = XMLConfigLoader.getInstance().load(ClassUtils.getDefaultClassLoader().getResourceAsStream(fileName));
                            if (!CollectionUtils.isEmpty(dsqls)) {
                                for (Dsql dsql : dsqls) {
                                    this.dsqls.put(dsql.getId(), dsql);
                                }
                            }
                            log.info("Finished parsing " + fileName);
                        }
                        continue;
                    }
                    log.warn("File with suffix: " + this.suffix + " not found in package " + basePackage);
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalConfigException("Failed to scan and load report configuration file from package: " + basePackage, e);
                }
            }
        }
    }
}

