/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsql.factory;

import cn.tenmg.dsl.DSLContext;
import cn.tenmg.dsl.ParamsConverter;
import cn.tenmg.dsl.ParamsFilter;
import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.context.DefaultDSLContext;
import cn.tenmg.dsl.parser.JDBCParamsParser;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsql.DSQLFactory;
import cn.tenmg.dsql.NamedSQL;
import cn.tenmg.dsql.config.model.Converter;
import cn.tenmg.dsql.config.model.Dsql;
import cn.tenmg.dsql.config.model.Filter;
import java.util.List;
import java.util.Map;

public abstract class AbstractDSQLFactory
implements DSQLFactory {
    private static final long serialVersionUID = 5184151389554035362L;

    abstract Map<String, Dsql> getDsqls();

    @Override
    public Dsql getDsql(String id) {
        return this.getDsqls().get(id);
    }

    @Override
    public String getScript(String id) {
        Dsql dsql = this.getDsql(id);
        return dsql == null ? null : dsql.getScript();
    }

    @Override
    public NamedSQL parse(Dsql dsql, Object ... params) {
        return new NamedSQL(dsql.getId(), DSLUtils.parse((DSLContext)new DefaultDSLContext(AbstractDSQLFactory.getParamsConverters(dsql), AbstractDSQLFactory.getParamsFilters(dsql)), (String)dsql.getScript(), (Object[])params));
    }

    @Override
    public NamedSQL parse(Dsql dsql, Object params) {
        return new NamedSQL(dsql.getId(), DSLUtils.parse((DSLContext)new DefaultDSLContext(AbstractDSQLFactory.getParamsConverters(dsql), AbstractDSQLFactory.getParamsFilters(dsql)), (String)dsql.getScript(), (Object)params));
    }

    @Override
    public NamedSQL parse(String dsql, Object ... params) {
        Dsql obj = this.getDsql(dsql);
        if (obj == null) {
            return new NamedSQL(DSLUtils.parse((String)dsql, (Object[])params));
        }
        return new NamedSQL(obj.getId(), DSLUtils.parse((DSLContext)new DefaultDSLContext(AbstractDSQLFactory.getParamsConverters(obj), AbstractDSQLFactory.getParamsFilters(obj)), (String)obj.getScript(), (Object[])params));
    }

    @Override
    public NamedSQL parse(String dsql, Object params) {
        Dsql obj = this.getDsql(dsql);
        if (obj == null) {
            return new NamedSQL(DSLUtils.parse((String)dsql, (Object)params));
        }
        return new NamedSQL(obj.getId(), DSLUtils.parse((DSLContext)new DefaultDSLContext(AbstractDSQLFactory.getParamsConverters(obj), AbstractDSQLFactory.getParamsFilters(obj)), (String)obj.getScript(), (Object)params));
    }

    @Override
    public Script<List<Object>> toJDBC(NamedSQL namedSQL) {
        return this.toJDBC(namedSQL.getScript(), namedSQL.getParams());
    }

    @Override
    public Script<List<Object>> toJDBC(String namedscript, Map<String, ?> params) {
        return DSLUtils.toScript((String)namedscript, params, (ParamsParser)JDBCParamsParser.getInstance());
    }

    private static List<ParamsConverter<?>> getParamsConverters(Dsql dsql) {
        Converter converter = dsql.getConverter();
        if (converter == null) {
            return null;
        }
        return converter.getParamsConverters();
    }

    private static List<ParamsFilter> getParamsFilters(Dsql dsql) {
        Filter filter = dsql.getFilter();
        if (filter == null) {
            return null;
        }
        return filter.getParamsFilters();
    }
}

