/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.dsql.factory;

import cn.tenmg.dsl.utils.ClassUtils;
import cn.tenmg.dsl.utils.CollectionUtils;
import cn.tenmg.dsl.utils.FileUtils;
import cn.tenmg.dsql.config.loader.XMLConfigLoader;
import cn.tenmg.dsql.config.model.Dsql;
import cn.tenmg.dsql.exception.LoadConfigException;
import cn.tenmg.dsql.factory.AbstractDSQLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLFileDSQLFactory
extends AbstractDSQLFactory {
    private static final long serialVersionUID = 8125151681490092061L;
    private static final Logger log = LoggerFactory.getLogger(XMLFileDSQLFactory.class);
    private final Map<String, Dsql> dsqls = new HashMap<String, Dsql>(512);
    private String basePackages;
    private String suffix = ".dsql.xml";

    public String getBasePackages() {
        return this.basePackages;
    }

    public void setBasePackages(String basePackages) {
        this.basePackages = basePackages;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public XMLFileDSQLFactory(String basePackages) {
        this.basePackages = basePackages;
        this.init();
    }

    public XMLFileDSQLFactory(String basePackages, String suffix) {
        this.basePackages = basePackages;
        this.suffix = suffix;
        this.init();
    }

    @Override
    Map<String, Dsql> getDsqls() {
        return this.dsqls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.basePackages == null) {
            log.warn("The parameter basePackages is null");
        } else {
            String[] basePackages = this.basePackages.split(",");
            for (int i = 0; i < basePackages.length; ++i) {
                String basePackage = basePackages[i];
                try {
                    log.info("Scan package: ".concat(basePackage));
                    List fileNames = FileUtils.scanPackage((String)basePackage, (String)this.suffix);
                    if (CollectionUtils.isNotEmpty((Collection)fileNames)) {
                        InputStream inStream = null;
                        int size = fileNames.size();
                        for (int j = 0; j < size; ++j) {
                            String fileName = (String)fileNames.get(j);
                            log.info("Start parsing " + fileName);
                            try {
                                inStream = ClassUtils.getDefaultClassLoader().getResourceAsStream(fileName);
                                List<Dsql> dsqls = XMLConfigLoader.getInstance().load(inStream);
                                if (CollectionUtils.isNotEmpty(dsqls)) {
                                    for (Dsql dsql : dsqls) {
                                        this.dsqls.put(dsql.getId(), dsql);
                                    }
                                }
                            }
                            finally {
                                if (inStream != null) {
                                    inStream.close();
                                    inStream = null;
                                }
                            }
                            log.info("Finished parsing " + fileName);
                        }
                        continue;
                    }
                    log.warn("File with suffix: " + this.suffix + " not found in package " + basePackage);
                    continue;
                }
                catch (IOException e) {
                    throw new LoadConfigException("Failed to scan and load report configuration file from package: " + basePackage, e);
                }
            }
        }
    }
}

