/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.cdc.log.debezium.history;

import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.document.Value;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class FlinkJsonTableChangeSerializer
implements TableChanges.TableChangesSerializer<Array> {
    public Array serialize(TableChanges tableChanges) {
        List values = StreamSupport.stream(tableChanges.spliterator(), false).map(this::toDocument).map(Value::create).collect(Collectors.toList());
        return Array.create(values);
    }

    public Document toDocument(TableChanges.TableChange tableChange) {
        Document document = Document.create();
        document.setString((CharSequence)"type", tableChange.getType().name());
        document.setString((CharSequence)"id", tableChange.getId().toDoubleQuotedString());
        document.setDocument((CharSequence)"table", this.toDocument(tableChange.getTable()));
        return document;
    }

    private Document toDocument(Table table) {
        Document document = Document.create();
        document.set((CharSequence)"defaultCharsetName", (Object)table.defaultCharsetName());
        document.set((CharSequence)"primaryKeyColumnNames", (Object)Array.create((Iterable)table.primaryKeyColumnNames()));
        List columns = table.columns().stream().map(this::toDocument).collect(Collectors.toList());
        document.setArray((CharSequence)"columns", Array.create(columns));
        return document;
    }

    private Document toDocument(Column column) {
        Document document = Document.create();
        document.setString((CharSequence)"name", column.name());
        document.setNumber((CharSequence)"jdbcType", column.jdbcType());
        if (column.nativeType() != -1) {
            document.setNumber((CharSequence)"nativeType", column.nativeType());
        }
        document.setString((CharSequence)"typeName", column.typeName());
        document.setString((CharSequence)"typeExpression", column.typeExpression());
        document.setString((CharSequence)"charsetName", column.charsetName());
        if (column.length() != -1) {
            document.setNumber((CharSequence)"length", column.length());
        }
        column.scale().ifPresent(s -> document.setNumber((CharSequence)"scale", s.intValue()));
        document.setNumber((CharSequence)"position", column.position());
        document.setBoolean((CharSequence)"optional", column.isOptional());
        document.setBoolean((CharSequence)"autoIncremented", column.isAutoIncremented());
        document.setBoolean((CharSequence)"generated", column.isGenerated());
        document.setArray((CharSequence)"enumValues", column.enumValues().toArray());
        return document;
    }

    public TableChanges deserialize(Array array, boolean useCatalogBeforeSchema) {
        TableChanges tableChanges = new TableChanges();
        for (Array.Entry entry : array) {
            TableChanges.TableChange change = FlinkJsonTableChangeSerializer.fromDocument(entry.getValue().asDocument(), useCatalogBeforeSchema);
            if (change.getType() == TableChanges.TableChangeType.CREATE) {
                tableChanges.create(change.getTable());
                continue;
            }
            if (change.getType() == TableChanges.TableChangeType.ALTER) {
                tableChanges.alter(change.getTable());
                continue;
            }
            if (change.getType() != TableChanges.TableChangeType.DROP) continue;
            tableChanges.drop(change.getTable());
        }
        return tableChanges;
    }

    private static Table fromDocument(TableId id, Document document) {
        TableEditor editor = Table.editor().tableId(id).setDefaultCharsetName(document.getString((CharSequence)"defaultCharsetName"));
        document.getArray((CharSequence)"columns").streamValues().map(Value::asDocument).map(v -> {
            Integer scale;
            ColumnEditor columnEditor = Column.editor().name(v.getString((CharSequence)"name")).jdbcType(v.getInteger((CharSequence)"jdbcType").intValue());
            Integer nativeType = v.getInteger((CharSequence)"nativeType");
            if (nativeType != null) {
                columnEditor.nativeType(nativeType.intValue());
            }
            columnEditor.type(v.getString((CharSequence)"typeName"), v.getString((CharSequence)"typeExpression")).charsetName(v.getString((CharSequence)"charsetName"));
            Integer length = v.getInteger((CharSequence)"length");
            if (length != null) {
                columnEditor.length(length.intValue());
            }
            if ((scale = v.getInteger((CharSequence)"scale")) != null) {
                columnEditor.scale(scale);
            }
            columnEditor.position(v.getInteger((CharSequence)"position").intValue()).optional(v.getBoolean((CharSequence)"optional").booleanValue()).autoIncremented(v.getBoolean((CharSequence)"autoIncremented").booleanValue()).generated(v.getBoolean((CharSequence)"generated").booleanValue());
            Array enumValues = v.getArray((CharSequence)"enumValues");
            if (enumValues != null && !enumValues.isEmpty()) {
                columnEditor.enumValues(enumValues.streamValues().map(Value::asString).collect(Collectors.toList()));
            }
            return columnEditor.create();
        }).forEach(arg_0 -> ((TableEditor)editor).addColumn(arg_0));
        editor.setPrimaryKeyNames(document.getArray((CharSequence)"primaryKeyColumnNames").streamValues().map(Value::asString).collect(Collectors.toList()));
        return editor.create();
    }

    public static TableChanges.TableChange fromDocument(Document document, boolean useCatalogBeforeSchema) {
        TableChanges.TableChangeType type = TableChanges.TableChangeType.valueOf((String)document.getString((CharSequence)"type"));
        TableId id = TableId.parse((String)document.getString((CharSequence)"id"), (boolean)useCatalogBeforeSchema);
        Table table = null;
        table = type == TableChanges.TableChangeType.CREATE || type == TableChanges.TableChangeType.ALTER ? FlinkJsonTableChangeSerializer.fromDocument(id, document.getDocument((CharSequence)"table")) : Table.editor().tableId(id).create();
        return new TableChanges.TableChange(type, table);
    }
}

