package cn.tenmg.flink.jobs.utils;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.tenmg.dsl.annotion.Macro;
import cn.tenmg.dsl.utils.FileUtils;

public class AnnotationUtils {

	private static final String CLASS_SUFFIX = ".class";

	private static final int CLASS_SUFFIX_LENTH = CLASS_SUFFIX.length();

	public static <A extends Annotation> Set<Class<?>> discoverClasses(Class<A> annotationClass,
			Set<String> basePackages) {
		Set<Class<?>> classes = new HashSet<Class<?>>();
		if (basePackages != null) {
			Class<?> c;
			List<String> paths;
			for (Iterator<String> it = basePackages.iterator(); it.hasNext();) {
				try {
					paths = FileUtils.scanPackage(it.next(), CLASS_SUFFIX);
					if (paths != null) {
						A annotation;
						for (int i = 0, size = paths.size(); i < size; i++) {
							try {
								c = Class.forName(toClassName(paths.get(i)));
								annotation = c.getAnnotation(annotationClass);
								if (annotation != null) {
									classes.add(c);
								}
							} catch (ClassNotFoundException e) {
								e.printStackTrace();
							}
						}
					}
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return classes;
	}

	public static Map<Annotation, Set<Class<?>>> discoverAnnotationClasses(Set<String> basePackages) {
		Map<Annotation, Set<Class<?>>> classes = new HashMap<Annotation, Set<Class<?>>>();
		if (basePackages != null) {
			Class<?> c;
			Set<Class<?>> set;
			List<String> paths;
			Annotation annotations[], annotation;
			for (Iterator<String> it = basePackages.iterator(); it.hasNext();) {
				try {
					paths = FileUtils.scanPackage(it.next(), CLASS_SUFFIX);
					if (paths != null) {

						for (int i = 0, size = paths.size(); i < size; i++) {
							try {
								c = Class.forName(toClassName(paths.get(i)));
								annotations = c.getAnnotations();
								if (annotations != null) {
									for (int j = 0; j < annotations.length; j++) {
										annotation = annotations[j];
										set = classes.get(annotation);
										if (set == null) {
											set = new HashSet<Class<?>>();
											classes.put(annotation, set);
										}
										set.add(c);
									}
								}
							} catch (ClassNotFoundException e) {
								e.printStackTrace();
							}
						}
					}
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return classes;
	}

	private static String toClassName(String path) {
		return path.substring(0, path.length() - CLASS_SUFFIX_LENTH).replaceAll("/", ".");
	}

	public static void main(String[] args) {
		System.out.println(discoverClasses(Macro.class, new HashSet<String>() {
			{
				add("");
			}
		}));

		System.out.println(discoverAnnotationClasses(new HashSet<String>() {
			{
				add("");
			}
		}));
	}
}
