/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.utils;

import cn.tenmg.dsl.annotion.Macro;
import cn.tenmg.dsl.utils.FileUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnnotationUtils {
    private static final String CLASS_SUFFIX = ".class";
    private static final int CLASS_SUFFIX_LENTH = ".class".length();

    public static <A extends Annotation> Set<Class<?>> discoverClasses(Class<A> annotationClass, Set<String> basePackages) {
        HashSet classes = new HashSet();
        if (basePackages != null) {
            Iterator<String> it = basePackages.iterator();
            while (it.hasNext()) {
                try {
                    List paths = FileUtils.scanPackage((String)it.next(), (String)CLASS_SUFFIX);
                    if (paths == null) continue;
                    int size = paths.size();
                    for (int i = 0; i < size; ++i) {
                        try {
                            Class<?> c = Class.forName(AnnotationUtils.toClassName((String)paths.get(i)));
                            A annotation = c.getAnnotation(annotationClass);
                            if (annotation == null) continue;
                            classes.add(c);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return classes;
    }

    public static Map<Annotation, Set<Class<?>>> discoverAnnotationClasses(Set<String> basePackages) {
        HashMap classes = new HashMap();
        if (basePackages != null) {
            Iterator<String> it = basePackages.iterator();
            while (it.hasNext()) {
                try {
                    List paths = FileUtils.scanPackage((String)it.next(), (String)CLASS_SUFFIX);
                    if (paths == null) continue;
                    int size = paths.size();
                    for (int i = 0; i < size; ++i) {
                        try {
                            Class<?> c = Class.forName(AnnotationUtils.toClassName((String)paths.get(i)));
                            Annotation[] annotations = c.getAnnotations();
                            if (annotations == null) continue;
                            for (int j = 0; j < annotations.length; ++j) {
                                Annotation annotation = annotations[j];
                                HashSet set = (HashSet)classes.get(annotation);
                                if (set == null) {
                                    set = new HashSet();
                                    classes.put(annotation, set);
                                }
                                set.add(c);
                            }
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return classes;
    }

    private static String toClassName(String path) {
        return path.substring(0, path.length() - CLASS_SUFFIX_LENTH).replaceAll("/", ".");
    }

    public static void main(String[] args) {
        System.out.println(AnnotationUtils.discoverClasses(Macro.class, (Set<String>)new HashSet<String>(){
            {
                this.add("");
            }
        }));
        System.out.println(AnnotationUtils.discoverAnnotationClasses((Set<String>)new HashSet<String>(){
            {
                this.add("");
            }
        }));
    }
}

