/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.utils;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public abstract class JDBCUtils {
    private static final String JDBC_PRODUCT_SPLIT = ":";

    private JDBCUtils() {
    }

    public static final String getProduct(String url) {
        String tmp = url.substring(url.indexOf(JDBC_PRODUCT_SPLIT) + 1);
        return tmp.substring(0, tmp.indexOf(JDBC_PRODUCT_SPLIT));
    }

    public static final Connection getConnection(Map<String, String> dataSource) throws SQLException, ClassNotFoundException {
        String driver = dataSource.get("driver");
        String url = dataSource.get("url");
        if (StringUtils.isBlank((String)driver)) {
            driver = FlinkJobsContext.getDefaultJDBCDriver(JDBCUtils.getProduct(url));
        }
        Class.forName(driver);
        return DriverManager.getConnection(url, dataSource.get("username"), dataSource.get("password"));
    }

    public static void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void setParams(PreparedStatement ps, List<Object> params) throws SQLException {
        if (params == null || params.isEmpty()) {
            return;
        }
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            ps.setObject(i + 1, params.get(i));
        }
    }
}

