/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.operator.data.sync.getter;

import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.kit.HashMapKit;
import cn.tenmg.flink.jobs.kit.ParamsKit;
import cn.tenmg.flink.jobs.operator.data.sync.MetaDataGetter;
import cn.tenmg.flink.jobs.utils.JDBCUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractJDBCMetaDataGetter
implements MetaDataGetter {
    protected static final String COLUMN_NAME = "COLUMN_NAME";
    protected static final String DATA_TYPE = "DATA_TYPE";
    protected static final String COLUMN_SIZE = "COLUMN_SIZE";
    protected static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    protected static final String IS_NULLABLE = "IS_NULLABLE";
    protected static final String NO = "NO";
    protected static final String LEFT_BRACKET = "(";
    protected static final String RIGTH_BRACKET = ")";
    protected static final String TYPE_PREFFIX = "flink.sql.type.";
    protected static final String DEFAULT_TYPE = FlinkJobsContext.getProperty("flink.sql.type.default");
    protected static final String SIZE_OFFSET_SUFFIX = ".size_offset";
    private static final Map<Integer, String> SQL_TYPES = HashMapKit.init(12, "java.sql.Types.VARCHAR").put(12, "java.sql.Types.VARCHAR").put(1, "java.sql.Types.CHAR").put(-9, "java.sql.Types.NVARCHAR").put(-15, "java.sql.Types.NCHAR").put(-16, "java.sql.Types.LONGNVARCHAR").put(-1, "java.sql.Types.LONGVARCHAR").put(-5, "java.sql.Types.BIGINT").put(16, "java.sql.Types.BOOLEAN").put(-7, "java.sql.Types.BIT").put(3, "java.sql.Types.DECIMAL").put(1111, "java.sql.Types.OTHER").put(8, "java.sql.Types.DOUBLE").put(6, "java.sql.Types.FLOAT").put(7, "java.sql.Types.REAL").put(4, "java.sql.Types.INTEGER").put(2, "java.sql.Types.NUMERIC").put(5, "java.sql.Types.SMALLINT").put(-6, "java.sql.Types.TINYINT").put(91, "java.sql.Types.DATE").put(92, "java.sql.Types.TIME").put(2013, "java.sql.Types.TIME_WITH_TIMEZONE").put(93, "java.sql.Types.TIMESTAMP").put(2014, "java.sql.Types.TIMESTAMP_WITH_TIMEZONE").put(-2, "java.sql.Types.BINARY").put(-4, "java.sql.Types.LONGVARBINARY").put(-3, "java.sql.Types.VARBINARY").put(2006, "java.sql.Types.REF").put(70, "java.sql.Types.DATALINK").put(2003, "java.sql.Types.ARRAY").put(2004, "java.sql.Types.BLOB").put(2005, "java.sql.Types.CLOB").put(2011, "java.sql.Types.NCLOB").put(2002, "java.sql.Types.STRUCT").get();
    private static Set<String> WITH_PRECISION = AbstractJDBCMetaDataGetter.asSafeSet(FlinkJobsContext.getProperty("flink.sql.type.with_precision"));
    private static Set<String> WITH_SIZE = AbstractJDBCMetaDataGetter.asSafeSet(FlinkJobsContext.getProperty("flink.sql.type.with_size"));

    abstract Connection getConnection(Map<String, String> var1) throws Exception;

    protected Set<String> getPrimaryKeys(Connection con, String catalog, String schema, String tableName) throws SQLException {
        ResultSet primaryKeysSet = con.getMetaData().getPrimaryKeys(catalog, schema, tableName);
        HashSet<String> primaryKeys = new HashSet<String>();
        while (primaryKeysSet.next()) {
            primaryKeys.add(primaryKeysSet.getString(COLUMN_NAME));
        }
        return primaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaDataGetter.TableMetaData getTableMetaData(Map<String, String> dataSource, String tableName) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection(dataSource);
            con.setAutoCommit(true);
            DatabaseMetaData metaData = con.getMetaData();
            String catalog = con.getCatalog();
            String schema = con.getSchema();
            Set<String> primaryKeys = this.getPrimaryKeys(con, catalog, schema, tableName);
            ResultSet columnsSet = metaData.getColumns(catalog, schema, tableName, null);
            LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
            while (columnsSet.next()) {
                String columnName = columnsSet.getString(COLUMN_NAME);
                String type = AbstractJDBCMetaDataGetter.getType(dataSource, columnsSet.getInt(DATA_TYPE), columnsSet.getInt(COLUMN_SIZE), columnsSet.getInt(DECIMAL_DIGITS));
                if (NO.equals(columnsSet.getString(IS_NULLABLE))) {
                    type = type + " NOT NULL";
                }
                columns.put(columnName, type);
            }
            MetaDataGetter.TableMetaData tableMetaData = new MetaDataGetter.TableMetaData(primaryKeys, columns);
            return tableMetaData;
        }
        finally {
            JDBCUtils.close(con);
        }
    }

    private static String getType(Map<String, String> dataSource, int dataType, int columnSize, int decimalDigits) {
        String sqlType = SQL_TYPES.get(dataType);
        String type = DEFAULT_TYPE;
        if (sqlType != null) {
            String url;
            String possibleType;
            String connector = dataSource.get("connector");
            String string = possibleType = connector == null ? null : AbstractJDBCMetaDataGetter.getSpecificProductType(connector.trim(), sqlType);
            if (StringUtils.isBlank((String)possibleType) && StringUtils.isNotBlank((String)(url = dataSource.get("url")))) {
                possibleType = AbstractJDBCMetaDataGetter.getSpecificProductType(JDBCUtils.getProduct(url), sqlType);
            }
            if (StringUtils.isBlank((String)possibleType)) {
                possibleType = FlinkJobsContext.getProperty(sqlType);
            }
            if (StringUtils.isBlank((String)possibleType)) {
                possibleType = FlinkJobsContext.getProperty(sqlType + LEFT_BRACKET + columnSize + "," + decimalDigits + RIGTH_BRACKET);
                if (StringUtils.isBlank((String)possibleType)) {
                    possibleType = FlinkJobsContext.getProperty(sqlType + LEFT_BRACKET + columnSize + RIGTH_BRACKET);
                    if (StringUtils.isNotBlank((String)possibleType)) {
                        type = possibleType;
                    }
                } else {
                    type = possibleType;
                }
            } else {
                type = possibleType;
            }
        }
        return AbstractJDBCMetaDataGetter.wrapType(type, columnSize, decimalDigits);
    }

    private static String getSpecificProductType(String product, String sqlType) {
        return FlinkJobsContext.getProperty(TYPE_PREFFIX + product + "." + sqlType);
    }

    private static String wrapType(String possibleType, int columnSize, int decimalDigits) {
        if ((possibleType = possibleType.trim()).endsWith(RIGTH_BRACKET)) {
            return DSLUtils.parse((String)possibleType, ParamsKit.init().put("columnSize", columnSize).put("decimalDigits", decimalDigits).get()).getScript();
        }
        if (WITH_PRECISION.contains(possibleType)) {
            return possibleType + LEFT_BRACKET + columnSize + "," + decimalDigits + RIGTH_BRACKET;
        }
        if (WITH_SIZE.contains(possibleType)) {
            String sizeOffset = FlinkJobsContext.getProperty(TYPE_PREFFIX + possibleType + SIZE_OFFSET_SUFFIX);
            if (StringUtils.isBlank((String)sizeOffset)) {
                return possibleType + LEFT_BRACKET + columnSize + RIGTH_BRACKET;
            }
            int offset = Integer.parseInt(sizeOffset);
            if (columnSize >= offset) {
                return possibleType + LEFT_BRACKET + (columnSize - offset) + RIGTH_BRACKET;
            }
        }
        return possibleType;
    }

    private static final Set<String> asSafeSet(String string) {
        HashSet<String> set = new HashSet<String>();
        if (string != null) {
            String[] strings = string.split(",");
            for (int i = 0; i < strings.length; ++i) {
                set.add(strings[i].trim());
            }
        }
        return set;
    }
}

