/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.metadata.getter;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.metadata.getter.AbstractJDBCMetaDataGetter;
import cn.tenmg.flink.jobs.utils.JDBCUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StarrocksMetaDataGetter
extends AbstractJDBCMetaDataGetter {
    private static final boolean ukAsPk = Boolean.valueOf(FlinkJobsContext.getProperty("metadata.starrocks.unique_key_as_primary_key"));

    @Override
    Connection getConnection(Map<String, String> dataSource) throws Exception {
        String driver = dataSource.get("driver");
        String url = dataSource.get("jdbc-url");
        String database = dataSource.get("database-name");
        if (StringUtils.isBlank((String)driver)) {
            driver = FlinkJobsContext.getDefaultJDBCDriver(JDBCUtils.getProduct(url));
        }
        if (StringUtils.isNotBlank((String)database)) {
            url = url + "/" + database;
        }
        Class.forName(driver);
        return DriverManager.getConnection(url, dataSource.get("username"), dataSource.get("password"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<String> getPrimaryKeys(Connection con, String catalog, String schema, String tableName) throws SQLException {
        HashSet<String> hashSet;
        StringBuilder sqlBuilder = new StringBuilder("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE COLUMN_KEY " + (ukAsPk ? "IN ('PRI','UNI')" : "= 'PRI'"));
        if (schema != null) {
            sqlBuilder.append(" AND TABLE_SCHEMA = ?");
        }
        sqlBuilder.append(" AND TABLE_NAME = ? ORDER BY ORDINAL_POSITION");
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sqlBuilder.toString());
            int nextId = 1;
            if (schema != null) {
                ps.setString(nextId++, schema);
            }
            ps.setString(nextId, tableName);
            rs = ps.executeQuery();
            HashSet<String> primaryKeys = new HashSet<String>();
            while (rs.next()) {
                primaryKeys.add(rs.getString("COLUMN_NAME"));
            }
            hashSet = primaryKeys;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close(ps);
            throw throwable;
        }
        JDBCUtils.close(rs);
        JDBCUtils.close(ps);
        return hashSet;
    }
}

